/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.api.clientcredentials;

import java.util.concurrent.ExecutionException;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.oauth2.internal.AbstractGrantType;
import org.mule.extension.oauth2.internal.store.SimpleObjectStoreToMapAdapter;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;

@NoExtend
@NoInstantiate
public class ClientCredentialsGrantType
extends AbstractGrantType {
    @Parameter
    @Optional(defaultValue="false")
    private boolean encodeClientCredentialsInBody;
    private ClientCredentialsOAuthDancer dancer;

    public final void initialise() throws InitialisationException {
        this.initTokenManager();
        OAuthClientCredentialsDancerBuilder dancerBuilder = this.oAuthService.clientCredentialsGrantTypeDancerBuilder(lockId -> this.muleContext.getLockFactory().createLock(lockId), new SimpleObjectStoreToMapAdapter<DefaultResourceOwnerOAuthContext>(this.tokenManager.getObjectStore()), (MuleExpressionLanguage)this.muleContext.getExpressionManager());
        dancerBuilder.encodeClientCredentialsInBody(this.isEncodeClientCredentialsInBody());
        dancerBuilder.clientCredentials(this.getClientId(), this.getClientSecret());
        this.configureBaseDancer((OAuthDancerBuilder)dancerBuilder);
        this.dancer = (ClientCredentialsOAuthDancer)dancerBuilder.build();
        LifecycleUtils.initialiseIfNeeded((Object)this.getDancer());
    }

    public void authenticate(HttpRequestBuilder builder) throws MuleException {
        try {
            builder.addHeader("Authorization", this.buildAuthorizationHeaderContent((String)this.dancer.accessToken().get()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DefaultMuleException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DefaultMuleException(e.getCause());
        }
    }

    public boolean shouldRetry(Result<Object, HttpResponseAttributes> firstAttemptResult) throws MuleException {
        Boolean shouldRetryRequest = this.resolver.resolveExpression(this.getRefreshTokenWhen(), firstAttemptResult);
        if (shouldRetryRequest.booleanValue()) {
            try {
                this.dancer.refreshToken().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DefaultMuleException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new DefaultMuleException(e.getCause());
            }
        }
        return shouldRetryRequest;
    }

    public void retryIfShould(Result<Object, HttpResponseAttributes> firstAttemptResult, Runnable retryCallback, Runnable notRetryCallback) {
        Boolean shouldRetryRequest = this.resolver.resolveExpression(this.getRefreshTokenWhen(), firstAttemptResult);
        if (shouldRetryRequest.booleanValue()) {
            this.dancer.refreshToken().thenRun(retryCallback);
        } else {
            notRetryCallback.run();
        }
    }

    public ClientCredentialsOAuthDancer getDancer() {
        return this.dancer;
    }

    @Override
    public boolean isEncodeClientCredentialsInBody() {
        return this.encodeClientCredentialsInBody;
    }
}

