/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.api.authorizationcode;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.oauth2.internal.AbstractGrantType;
import org.mule.extension.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.extension.oauth2.internal.store.SimpleObjectStoreToMapAdapter;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="authorization-code-grant-type")
@NoExtend
@NoInstantiate
public class DefaultAuthorizationCodeGrantType
extends AbstractGrantType {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizationCodeGrantType.class);
    @Parameter
    @Optional
    @ConfigReference(namespace="HTTP", name="LISTENER_CONFIG")
    private String localCallbackConfig;
    @Parameter
    @Optional
    private String localCallbackConfigPath;
    @Parameter
    @Optional
    private String localCallbackUrl;
    @Parameter
    private String externalCallbackUrl;
    @Parameter
    @Optional
    private Literal<String> state;
    @Parameter
    @Optional
    private Literal<String> localAuthorizationUrlResourceOwnerId;
    @Parameter
    private String localAuthorizationUrl;
    @Parameter
    private String authorizationUrl;
    @Parameter
    @Optional
    @Alias(value="custom-parameters")
    private Map<String, String> customParameters = new HashMap<String, String>();
    @Parameter
    @Optional(defaultValue="default")
    private ParameterResolver<String> resourceOwnerId;
    @Parameter
    @Optional(defaultValue="true")
    private boolean encodeClientCredentialsInBody;
    @Inject
    private HttpService httpService;
    private AuthorizationCodeOAuthDancer dancer;

    public String getLocalCallbackConfig() {
        return this.localCallbackConfig;
    }

    public String getLocalCallbackConfigPath() {
        return this.localCallbackConfigPath;
    }

    public String getLocalCallbackUrl() {
        return this.localCallbackUrl;
    }

    public String getExternalCallbackUrl() {
        return this.externalCallbackUrl;
    }

    public ConfigOAuthContext getUserOAuthContext() {
        return this.tokenManager.getConfigOAuthContext();
    }

    public final void initialise() throws InitialisationException {
        this.initTokenManager();
        OAuthAuthorizationCodeDancerBuilder dancerBuilder = this.configDancer(this.oAuthService);
        if (!this.isEncodeClientCredentialsInBody()) {
            try {
                OAuthAuthorizationCodeDancerBuilder.class.getDeclaredMethod("encodeClientCredentialsInBody", Boolean.TYPE).invoke((Object)dancerBuilder, this.isEncodeClientCredentialsInBody());
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("`encodeClientCredentialsInBody` method not found in dancer builder but configured in authenticator. The configured value will be ignored. Check the version of the Mule Runtime.");
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        dancerBuilder.clientCredentials(this.getClientId(), this.getClientSecret());
        this.configureBaseDancer((OAuthDancerBuilder)dancerBuilder);
        this.dancer = (AuthorizationCodeOAuthDancer)dancerBuilder.build();
        LifecycleUtils.initialiseIfNeeded((Object)this.getDancer());
    }

    private OAuthAuthorizationCodeDancerBuilder configDancer(OAuthService oauthService) throws InitialisationException {
        OAuthAuthorizationCodeDancerBuilder dancerBuilder = oauthService.authorizationCodeGrantTypeDancerBuilder(lockId -> this.muleContext.getLockFactory().createLock(lockId), new SimpleObjectStoreToMapAdapter<DefaultResourceOwnerOAuthContext>(this.tokenManager.getObjectStore()), (MuleExpressionLanguage)this.muleContext.getExpressionManager());
        try {
            if (this.localCallbackConfig != null && this.localCallbackUrl != null) {
                throw new IllegalArgumentException("Attributes localCallbackConfig and localCallbackUrl are mutually exclusive");
            }
            if (this.localCallbackConfig == null != (this.localCallbackConfigPath == null)) {
                throw new IllegalArgumentException("Attributes localCallbackConfig and localCallbackConfigPath must be both present or absent");
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        try {
            if (this.localCallbackUrl != null) {
                if (!this.localCallbackUrl.startsWith("urn:")) {
                    dancerBuilder = this.getTlsContextFactory() != null ? dancerBuilder.localCallback(new URL(this.localCallbackUrl), this.getTlsContextFactory()) : dancerBuilder.localCallback(new URL(this.localCallbackUrl));
                }
            } else if (this.localCallbackConfig != null) {
                HttpServer server = this.httpService.getServerFactory().lookup(this.localCallbackConfig);
                dancerBuilder = dancerBuilder.localCallback(server, this.localCallbackConfigPath);
            }
            dancerBuilder = dancerBuilder.localAuthorizationUrlPath(new URL(this.localAuthorizationUrl).getPath()).localAuthorizationUrlResourceOwnerId(this.resolver.getExpression(this.localAuthorizationUrlResourceOwnerId)).customParameters(this.customParameters).state(this.resolver.getExpression(this.state)).authorizationUrl(this.authorizationUrl).externalCallbackUrl(this.externalCallbackUrl);
            return dancerBuilder;
        }
        catch (MalformedURLException | ServerNotFoundException e) {
            throw new InitialisationException(e, (Initialisable)this);
        }
    }

    public void authenticate(HttpRequestBuilder builder) throws MuleException {
        try {
            builder.addHeader("Authorization", this.buildAuthorizationHeaderContent((String)this.dancer.accessToken((String)this.resourceOwnerId.resolve()).get()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DefaultMuleException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DefaultMuleException(e.getCause());
        }
    }

    public boolean shouldRetry(Result<Object, HttpResponseAttributes> firstAttemptResult) throws MuleException {
        Boolean shouldRetryRequest = this.resolver.resolveExpression(this.getRefreshTokenWhen(), firstAttemptResult);
        if (shouldRetryRequest.booleanValue()) {
            try {
                this.dancer.refreshToken((String)this.resourceOwnerId.resolve()).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DefaultMuleException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new DefaultMuleException(e.getCause());
            }
        }
        return shouldRetryRequest;
    }

    public AuthorizationCodeOAuthDancer getDancer() {
        return this.dancer;
    }

    @Override
    public boolean isEncodeClientCredentialsInBody() {
        return this.encodeClientCredentialsInBody;
    }
}

