/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal.tokenmanager;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.extension.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.util.store.MuleObjectStoreManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;

@Alias(value="token-manager-config")
@XmlHints(allowTopLevelDefinition=true)
public class TokenManagerConfig
implements Initialisable,
MuleContextAware {
    public static AtomicInteger defaultTokenManagerConfigIndex = new AtomicInteger(0);
    @ConfigName
    private String name;
    @Parameter
    @Optional
    private ListableObjectStore<DefaultResourceOwnerOAuthContext> objectStore;
    private MuleContext muleContext;
    private ConfigOAuthContext configOAuthContext;
    private boolean initialised;

    public ListableObjectStore<DefaultResourceOwnerOAuthContext> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ListableObjectStore<DefaultResourceOwnerOAuthContext> objectStore) {
        this.objectStore = objectStore;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialised) {
            return;
        }
        if (this.objectStore == null) {
            this.objectStore = (ListableObjectStore)((MuleObjectStoreManager)this.muleContext.getObjectStoreManager()).getUserObjectStore("token-manager-store-" + this.name, true);
        }
        this.configOAuthContext = new ConfigOAuthContext(this.muleContext.getLockFactory(), this.objectStore, this.name);
        this.initialised = true;
    }

    public static TokenManagerConfig createDefault(MuleContext context) throws InitialisationException {
        TokenManagerConfig tokenManagerConfig = new TokenManagerConfig();
        String tokenManagerConfigName = "default-token-manager-config-" + defaultTokenManagerConfigIndex.getAndIncrement();
        tokenManagerConfig.setName(tokenManagerConfigName);
        try {
            context.getRegistry().registerObject(tokenManagerConfigName, (Object)tokenManagerConfig);
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)tokenManagerConfig);
        }
        return tokenManagerConfig;
    }

    public ConfigOAuthContext getConfigOAuthContext() {
        return this.configOAuthContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

