
package org.mule.modules.zuora.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/zuora</code>.
 * 
 */
public class ZuoraModuleNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new ZuoraModuleConfigDefinitionParser());
        registerBeanDefinitionParser("subscribe", new SubscribeDefinitionParser());
        registerBeanDefinitionParser("create", new CreateDefinitionParser());
        registerBeanDefinitionParser("generate", new GenerateDefinitionParser());
        registerBeanDefinitionParser("update", new UpdateDefinitionParser());
        registerBeanDefinitionParser("delete", new DeleteDefinitionParser());
        registerBeanDefinitionParser("find", new FindDefinitionParser());
        registerBeanDefinitionParser("product-profile", new ProductProfileDefinitionParser());
        registerBeanDefinitionParser("get-user-info", new GetUserInfoDefinitionParser());
        registerBeanDefinitionParser("amend", new AmendDefinitionParser());
        registerBeanDefinitionParser("account-profile", new AccountProfileDefinitionParser());
        registerBeanDefinitionParser("get-invoice", new GetInvoiceDefinitionParser());
    }

}
