
package org.mule.modules.zuora.adapters;

import org.mule.api.Capabilities;
import org.mule.api.Capability;


/**
 * A <code>ZuoraModuleCapabilitiesAdapter</code> is a wrapper around {@link org.mule.modules.zuora.ZuoraModule } that implements {@link org.mule.api.Capabilities} interface.
 * 
 */
public class ZuoraModuleCapabilitiesAdapter
    extends org.mule.modules.zuora.ZuoraModule
    implements Capabilities
{


    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == Capability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

}
