/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.utils.pagination;

import java.util.Iterator;

public abstract class PaginatedIterable<T, Page>
implements Iterable<T> {
    @Override
    public Iterator<T> iterator() {
        final Page initialPageInfo = this.firstPage();
        return new Iterator<T>(){
            private Page currentList;
            private Iterator<T> currentIter;
            {
                this.currentList = initialPageInfo;
                this.currentIter = PaginatedIterable.this.pageIterator(initialPageInfo);
            }

            @Override
            public boolean hasNext() {
                this.updateIter();
                return this.currentIter.hasNext();
            }

            @Override
            public T next() {
                this.updateIter();
                return this.currentIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void updateIter() {
                if (!this.currentIter.hasNext() && PaginatedIterable.this.hasNextPage(this.currentList)) {
                    this.currentList = PaginatedIterable.this.nextPage(this.currentList);
                    this.currentIter = PaginatedIterable.this.pageIterator(this.currentList);
                }
            }
        };
    }

    protected abstract Page firstPage();

    protected abstract Page nextPage(Page var1);

    protected abstract boolean hasNextPage(Page var1);

    protected abstract Iterator<T> pageIterator(Page var1);
}

