/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ActionExpressionHolder;
import org.mule.modules.zendesk.model.holders.MacroExpressionHolder;
import org.mule.modules.zendesk.model.holders.RestrictionExpressionHolder;
import org.mule.modules.zendesk.processors.UpdateMacroMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateMacroDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(UpdateMacroDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)UpdateMacroMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [update-macro] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [update-macro] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"updateMacro");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "macro", "macro", "#[payload]")) {
            BeanDefinitionBuilder macroBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)MacroExpressionHolder.class.getName());
            Element macroChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"macro");
            if (macroChildElement != null) {
                this.parseProperty(macroBuilder, macroChildElement, "id", "id");
                this.parseProperty(macroBuilder, macroChildElement, "url", "url");
                this.parseProperty(macroBuilder, macroChildElement, "createdAt", "createdAt");
                this.parseProperty(macroBuilder, macroChildElement, "updatedAt", "updatedAt");
                this.parseProperty(macroBuilder, macroChildElement, "title", "title");
                this.parseProperty(macroBuilder, macroChildElement, "active", "active");
                if (!this.parseObjectRef(macroChildElement, macroBuilder, "restriction", "restriction")) {
                    BeanDefinitionBuilder _restrictionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)RestrictionExpressionHolder.class.getName());
                    Element _restrictionChildElement = DomUtils.getChildElementByTagName((Element)macroChildElement, (String)"restriction");
                    if (_restrictionChildElement != null) {
                        this.parseProperty(_restrictionBuilder, _restrictionChildElement, "id", "id");
                        this.parseProperty(_restrictionBuilder, _restrictionChildElement, "type", "type");
                        macroBuilder.addPropertyValue("restriction", (Object)_restrictionBuilder.getBeanDefinition());
                    }
                }
                if (!this.parseObjectRef(macroChildElement, macroBuilder, "actions", "actions")) {
                    BeanDefinitionBuilder _actionsBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)ActionExpressionHolder.class.getName());
                    Element _actionsChildElement = DomUtils.getChildElementByTagName((Element)macroChildElement, (String)"actions");
                    if (_actionsChildElement != null) {
                        this.parseProperty(_actionsBuilder, _actionsChildElement, "field", "field");
                        this.parseProperty(_actionsBuilder, _actionsChildElement, "value", "value");
                        macroBuilder.addPropertyValue("actions", (Object)_actionsBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("macro", (Object)macroBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

