/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.CustomFieldExpressionHolder;
import org.mule.modules.zendesk.model.holders.RequestExpressionHolder;
import org.mule.modules.zendesk.model.holders.ViaExpressionHolder;
import org.mule.modules.zendesk.processors.CreateRequestMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateRequestDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateRequestDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)CreateRequestMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-request] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-request] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"createRequest");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "request", "request", "#[payload]")) {
            BeanDefinitionBuilder requestBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)RequestExpressionHolder.class.getName());
            Element requestChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"request");
            if (requestChildElement != null) {
                this.parseProperty(requestBuilder, requestChildElement, "id", "id");
                this.parseProperty(requestBuilder, requestChildElement, "url", "url");
                this.parseProperty(requestBuilder, requestChildElement, "createdAt", "createdAt");
                this.parseProperty(requestBuilder, requestChildElement, "updatedAt", "updatedAt");
                this.parseProperty(requestBuilder, requestChildElement, "subject", "subject");
                this.parseProperty(requestBuilder, requestChildElement, "description", "description");
                this.parseProperty(requestBuilder, requestChildElement, "status", "status");
                this.parseListAndSetProperty(requestChildElement, requestBuilder, "customFields", "custom-fields", "custom-field", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<BeanDefinition>(){

                    public BeanDefinition parse(Element element) {
                        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CustomFieldExpressionHolder.class);
                        CreateRequestDefinitionParser.this.parseProperty(builder, element, "id", "id");
                        CreateRequestDefinitionParser.this.parseProperty(builder, element, "value", "value");
                        CreateRequestDefinitionParser.this.parseProperty(builder, element, "url", "url");
                        CreateRequestDefinitionParser.this.parseProperty(builder, element, "title", "title");
                        return builder.getBeanDefinition();
                    }
                });
                this.parseProperty(requestBuilder, requestChildElement, "organizationId", "organizationId");
                this.parseProperty(requestBuilder, requestChildElement, "requesterid", "requesterid");
                if (!this.parseObjectRef(requestChildElement, requestBuilder, "via", "via")) {
                    BeanDefinitionBuilder _viaBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)ViaExpressionHolder.class.getName());
                    Element _viaChildElement = DomUtils.getChildElementByTagName((Element)requestChildElement, (String)"via");
                    if (_viaChildElement != null) {
                        this.parseProperty(_viaBuilder, _viaChildElement, "channel", "channel");
                        if (this.hasAttribute(_viaChildElement, "source-ref")) {
                            if (_viaChildElement.getAttribute("source-ref").startsWith("#")) {
                                _viaBuilder.addPropertyValue("source", (Object)_viaChildElement.getAttribute("source-ref"));
                            } else {
                                _viaBuilder.addPropertyValue("source", (Object)("#[registry:" + _viaChildElement.getAttribute("source-ref") + "]"));
                            }
                        }
                        requestBuilder.addPropertyValue("via", (Object)_viaBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("request", (Object)requestBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

