/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.defs.tuple.Tuple2;
import net.sf.staccatocommons.lang.tuple.AbstractTuple;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class Pair<A, B>
extends AbstractTuple
implements Tuple2<A, B> {
    private static final long serialVersionUID = -6479045670420592337L;
    private static final RelevantState<Tuple2> VAL = new AbstractTuple.TupleState<Tuple2>(2){

        @Override
        protected void collectState(Tuple2 o, RelevantState.StateCollector s) {
            s.add(o.first()).add(o.second());
        }
    };
    private final A first;
    private final B second;

    public Pair(A fist, B second) {
        this.first = fist;
        this.second = second;
    }

    @Override
    public A first() {
        return this.first;
    }

    @Override
    public A _0() {
        return this.first;
    }

    @Override
    public B second() {
        return this.second;
    }

    @Override
    public B _1() {
        return this.second;
    }

    @Override
    @NonNull
    public Pair<B, A> swap() {
        return new Pair<B, A>(this.second, this.first);
    }

    public String toString() {
        return VAL.toString(this);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return new Object[]{this.first, this.second};
    }

    @Override
    public int compareTo(Tuple2<A, B> other) {
        return VAL.compareTo(this, other);
    }

    @Override
    public int hashCode() {
        return VAL.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return VAL.equals(this, obj);
    }

    @Override
    public A getKey() {
        return this.first();
    }

    @Override
    public B getValue() {
        return this.second();
    }

    @Override
    public B setValue(B arg0) {
        throw new UnsupportedOperationException();
    }
}

