/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.thunk;

import java.util.Date;
import java.util.concurrent.Callable;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.iterators.thriter.internal.ConstantThunk;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.thunk.internal.DateThunk;
import net.sf.staccatocommons.lang.thunk.internal.FailThunk;
import net.sf.staccatocommons.lang.thunk.internal.NullThunk;
import net.sf.staccatocommons.lang.thunk.internal.UndefinedThunk;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Thunks {
    private static final Function VALUE = Thunks.valueInitializer();

    private Thunks() {
    }

    public static <A> Thunk<A> constant(A value) {
        return new ConstantThunk<A>(value);
    }

    @Constant
    public static <A> Thunk<A> null_() {
        return NullThunk.null_();
    }

    @Constant
    public static Thunk<Date> currentDate() {
        return DateThunk.INSTANCE;
    }

    public static <A> Thunk<A> from(final @NonNull Callable<A> callable) {
        Ensure.isNotNull("var0", callable);
        return new Thunk<A>(){

            @Override
            public A value() {
                return SoftException.callOrSoften(callable);
            }
        };
    }

    @Constant
    public static <A> Thunk<A> undefined() {
        return UndefinedThunk.undefined();
    }

    public static <A> Thunk<A> fail(@NonNull String message, Object ... args) {
        Ensure.isNotNull("var0", message);
        return new FailThunk(message, args);
    }

    public static Thunk<Void> from(final @NonNull Runnable runnable) {
        Ensure.isNotNull("var0", runnable);
        return new Thunk<Void>(){

            @Override
            public Void value() {
                runnable.run();
                return null;
            }
        };
    }

    @Constant
    public static <A> Function<Thunk<A>, A> value() {
        return VALUE;
    }

    private static Function valueInitializer() {
        return new AbstractFunction<Thunk<A>, A>(){

            @Override
            public A apply(Thunk<A> arg) {
                return arg.value();
            }
        };
    }
}

