/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.iterable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.check.internal.SizeAwareTypes;
import net.sf.staccatocommons.collections.iterable.ModifiableIterables;
import net.sf.staccatocommons.collections.iterable.internal.IterablesInternal;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Applicable2;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Evaluable2;
import net.sf.staccatocommons.defs.reduction.Accumulator;
import net.sf.staccatocommons.defs.reduction.Reduction;
import net.sf.staccatocommons.defs.tuple.Tuple2;
import net.sf.staccatocommons.defs.type.NumberType;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.lang.predicate.Equiv;
import net.sf.staccatocommons.lang.tuple.Tuples;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import net.sf.staccatocommons.restrictions.check.NotNegative;
import net.sf.staccatocommons.restrictions.check.Size;
import net.sf.staccatocommons.restrictions.processing.IgnoreRestrictions;
import org.apache.commons.lang.ObjectUtils;

public class Iterables {
    @NonNull
    public static <A> List<A> filter(@NonNull Iterable<A> iterable, @NonNull Evaluable<? super A> predicate) {
        Ensure.isNotNull("var1", predicate);
        Ensure.isNotNull("var0", iterable);
        return IterablesInternal.filterInternal(iterable, predicate, new LinkedList());
    }

    @NonNull
    public static <A> List<A> take(@NonNull Iterable<A> iterable, @NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var1", amountOfElements);
        Ensure.isNotNull("var0", iterable);
        return IterablesInternal.takeInternal(iterable, amountOfElements, new ArrayList(amountOfElements));
    }

    @NonNull
    @IgnoreRestrictions
    public static <A> A reduce(@NotEmpty Iterable<A> iterable, @NonNull Applicable2<? super A, ? super A, ? extends A> function) {
        Ensure.isNotNull("function", function);
        Iterator<A> iter = iterable.iterator();
        if (!iter.hasNext()) {
            Ensure.fail("iterable", iterable, "Must be not empty", new Object[0]);
        }
        A result = iter.next();
        while (iter.hasNext()) {
            result = function.apply(result, iter.next());
        }
        return result;
    }

    @NonNull
    public static <A, B> B fold(@NonNull Iterable<A> iterable, B initial, @NonNull Applicable2<? super B, ? super A, ? extends B> function) {
        Ensure.isNotNull("var2", function);
        Ensure.isNotNull("var0", iterable);
        B result = initial;
        for (A element : iterable) {
            result = function.apply(result, element);
        }
        return result;
    }

    @NonNull
    public static <A, B> B reduce(@NonNull Iterable<A> iterable, @NonNull Reduction<? super A, B> reduction) {
        Ensure.isNotNull("var1", reduction);
        Ensure.isNotNull("var0", iterable);
        Accumulator<A, B> accum = reduction.newAccumulator();
        for (A element : iterable) {
            accum.accumulate(element);
        }
        return accum.value();
    }

    public static <A> A find(@NonNull Iterable<A> iterable, @NonNull Evaluable<? super A> predicate) {
        Ensure.isNotNull("var1", predicate);
        Ensure.isNotNull("var0", iterable);
        for (A o : iterable) {
            if (!predicate.eval(o)) continue;
            return o;
        }
        throw new NoSuchElementException();
    }

    @NonNull
    public static <A> Option<A> findOrNone(@NonNull Iterable<A> iterable, @NonNull Evaluable<? super A> predicate) {
        Ensure.isNotNull("var1", predicate);
        Ensure.isNotNull("var0", iterable);
        for (A o : iterable) {
            if (!predicate.eval(o)) continue;
            return Option.some(o);
        }
        return Option.none();
    }

    public static <A> A single(@Size(value=1) Collection<A> collection) {
        Ensure.that().isSize("var0", collection, 1, SizeAwareTypes.COLLECTION);
        return Iterables.any(collection);
    }

    public static <A> A any(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        return iterable.iterator().next();
    }

    @NonNull
    public static <A> Option<A> anyOrNone(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        Iterator<A> iterator = iterable.iterator();
        return iterator.hasNext() ? (Option)Option.some(iterator.next()) : (Option)Option.none();
    }

    public static <A> boolean all(@NonNull Iterable<A> iterable, @NonNull Evaluable<? super A> predicate) {
        Ensure.isNotNull("var1", predicate);
        Ensure.isNotNull("var0", iterable);
        for (A o : iterable) {
            if (predicate.eval(o)) continue;
            return false;
        }
        return true;
    }

    public static <A> boolean allEquivBy(@NonNull Iterable<A> iterable, Evaluable2<? super A, ? super A> equivTest) {
        Ensure.isNotNull("var0", iterable);
        Iterator<A> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return true;
        }
        A any = iter.next();
        while (iter.hasNext()) {
            if (equivTest.eval(any, iter.next())) continue;
            return false;
        }
        return true;
    }

    public static <A> boolean allEqual(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        return Iterables.allEquivBy(iterable, Equiv.equal());
    }

    public static <A> boolean allSame(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        return Iterables.allEquivBy(iterable, Equiv.same());
    }

    public static <A> boolean any(@NonNull Iterable<A> iterable, Evaluable<? super A> predicate) {
        Ensure.isNotNull("var0", iterable);
        for (A o : iterable) {
            if (!predicate.eval(o)) continue;
            return true;
        }
        return false;
    }

    public static <A> boolean isEmpty(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        return !iterable.iterator().hasNext();
    }

    public static <A> boolean isNullOrEmpty(Iterable<A> iterable) {
        return iterable == null || Iterables.isEmpty(iterable);
    }

    public static <A> boolean isNullOrEmpty(Collection<A> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int size(@NonNull Iterable<?> iterable) {
        Ensure.isNotNull("var0", iterable);
        int size = 0;
        Iterator<?> iter = iterable.iterator();
        while (iter.hasNext()) {
            ++size;
            iter.next();
        }
        return size;
    }

    public static <A> boolean equiv(@NonNull Iterable<? extends A> iterable1, @NonNull Iterable<? extends A> iterable2) {
        Ensure.isNotNull("var1", iterable2);
        Ensure.isNotNull("var0", iterable1);
        return Iterables.equivBy(iterable1, iterable2, Equiv.equal().nullSafe());
    }

    public static <A> boolean equivBy(@NonNull Iterable<? extends A> iterable1, @NonNull Iterable<? extends A> iterable2, Evaluable2<? super A, ? super A> equivTest) {
        Ensure.isNotNull("var1", iterable2);
        Ensure.isNotNull("var0", iterable1);
        Iterator<A> iter = iterable1.iterator();
        Iterator<A> otherIter = iterable2.iterator();
        while (iter.hasNext()) {
            if (!otherIter.hasNext()) {
                return false;
            }
            if (equivTest.eval(iter.next(), otherIter.next())) continue;
            return false;
        }
        return !otherIter.hasNext();
    }

    @NonNull
    public static <A, B> List<B> map(@NonNull Collection<A> collection, @NonNull Applicable<? super A, ? extends B> function) {
        Ensure.isNotNull("var1", function);
        Ensure.isNotNull("var0", collection);
        return IterablesInternal.collectInternal(collection, function, new ArrayList(collection.size()));
    }

    @NonNull
    public static <A, B> List<B> map(@NonNull Iterable<A> iterable, @NonNull Applicable<? super A, ? extends B> function) {
        Ensure.isNotNull("var1", function);
        Ensure.isNotNull("var0", iterable);
        return IterablesInternal.collectInternal(iterable, function, new LinkedList());
    }

    @NonNull
    public static <A, B> List<B> flatMap(@NonNull Iterable<A> iterable, @NonNull Applicable<? super A, ? extends Iterable<B>> function) {
        Ensure.isNotNull("var1", function);
        Ensure.isNotNull("var0", iterable);
        LinkedList<B> list = new LinkedList<B>();
        for (A element : iterable) {
            for (B applyedElement : function.apply(element)) {
                list.add(applyedElement);
            }
        }
        return list;
    }

    @NonNull
    public static <A> List<A> toSortedList(@NonNull Iterable<A> iterable, @NonNull Comparator<? super A> comparator) {
        Ensure.isNotNull("var1", comparator);
        Ensure.isNotNull("var0", iterable);
        LinkedList list = new LinkedList();
        IterablesInternal.addAllInternal(list, iterable);
        Collections.sort(list, comparator);
        return list;
    }

    @NonNull
    public static <A> SortedSet<A> toSortedSet(@NonNull Iterable<A> iterable, @NonNull Comparator<? super A> comparator) {
        Ensure.isNotNull("var1", comparator);
        Ensure.isNotNull("var0", iterable);
        TreeSet<? super A> sortedSet = new TreeSet<A>(comparator);
        IterablesInternal.addAllInternal(sortedSet, iterable);
        return sortedSet;
    }

    @NonNull
    public static <A extends Comparable<A>> SortedSet<A> toSortedSet(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        TreeSet sortedSet = new TreeSet();
        IterablesInternal.addAllInternal(sortedSet, iterable);
        return sortedSet;
    }

    public static <A> Set<A> toSet(A ... elements) {
        return Iterables.toSet((Iterable)Arrays.asList(elements));
    }

    public static <A> Set<A> toSet(Collection<A> collection) {
        return collection instanceof Set ? (Set<Object>)collection : new HashSet<A>(collection);
    }

    @NonNull
    public static <A> Set<A> toSet(@NonNull Iterable<A> iterable) {
        Ensure.isNotNull("var0", iterable);
        return ModifiableIterables.addAll(new HashSet(), iterable);
    }

    public static <A> List<A> toList(@NonNull Collection<A> collection) {
        Ensure.isNotNull("var0", collection);
        return collection instanceof List ? (List<Object>)collection : new ArrayList<A>(collection);
    }

    public static <A> List<A> toList(Iterable<A> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        LinkedList list = new LinkedList();
        ModifiableIterables.addAll(list, iterable);
        return list;
    }

    public static <A> Tuple2<List<A>, List<A>> partition(@NonNull Iterable<A> iterable, Evaluable<? super A> predicate) {
        Ensure.isNotNull("var0", iterable);
        LinkedList<A> first = new LinkedList<A>();
        LinkedList<A> second = new LinkedList<A>();
        for (A element : iterable) {
            if (predicate.eval(element)) {
                first.add(element);
                continue;
            }
            second.add(element);
        }
        return Tuples._(first, second);
    }

    public static <A> A get(@NonNull Iterable<A> iterable, int n) throws IndexOutOfBoundsException {
        Ensure.isNotNull("var0", iterable);
        A element = null;
        Iterator<A> iter = iterable.iterator();
        int i = 0;
        while (i <= n) {
            try {
                element = iter.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IndexOutOfBoundsException("At " + n);
            }
            ++i;
        }
        return element;
    }

    public static <A> int indexOf(@NonNull Iterable<A> iterable, A element) {
        Ensure.isNotNull("var0", iterable);
        int i = 0;
        for (A o : iterable) {
            if (ObjectUtils.equals(element, o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <A> boolean isBefore(@NonNull Iterable<A> iterable, A previous, A next) {
        Ensure.isNotNull("var0", iterable);
        if (ObjectUtils.equals(previous, next)) {
            return false;
        }
        boolean previousFound = false;
        for (A o : iterable) {
            if (!previousFound && ObjectUtils.equals(o, previous)) {
                previousFound = true;
                continue;
            }
            if (!ObjectUtils.equals(o, next)) continue;
            return previousFound;
        }
        return false;
    }

    @NonNull
    public static <A, B, C> List<C> zip(@NonNull Iterable<A> iterable1, @NonNull Iterable<B> iterable2, Applicable2<A, B, C> function) {
        Ensure.isNotNull("var1", iterable2);
        Ensure.isNotNull("var0", iterable1);
        Iterator<A> iter1 = iterable1.iterator();
        Iterator<B> iter2 = iterable2.iterator();
        LinkedList<C> result = new LinkedList<C>();
        while (iter1.hasNext() && iter2.hasNext()) {
            result.add(function.apply(iter1.next(), iter2.next()));
        }
        return result;
    }

    @NonNull
    public static <A, B> List<Tuple2<A, B>> zip(@NonNull Iterable<A> iterable1, @NonNull Iterable<B> iterable2) {
        Ensure.isNotNull("var1", iterable2);
        Ensure.isNotNull("var0", iterable1);
        return Iterables.zip(iterable1, iterable2, Tuples.toTuple2());
    }

    @NonNull
    public static <A> A sum(@NonNull Iterable<A> iterable, @NonNull NumberType<A> type) {
        Ensure.isNotNull("var1", type);
        Ensure.isNotNull("var0", iterable);
        return Iterables.fold(iterable, type.zero(), (Applicable2)type.add());
    }

    @NonNull
    public static <A> A product(@NonNull Iterable<A> iterable, @NonNull NumberType<A> type) {
        Ensure.isNotNull("var1", type);
        Ensure.isNotNull("var0", iterable);
        return Iterables.fold(iterable, type.one(), (Applicable2)type.multiply());
    }

    @NonNull
    public static final <A, B> List<Tuple2<A, B>> cross(@NonNull Iterable<A> iterable1, @NonNull Iterable<B> iterable2) {
        Ensure.isNotNull("var1", iterable2);
        Ensure.isNotNull("var0", iterable1);
        return Iterables.cross(iterable1, iterable2, new LinkedList<Tuple2<A, B>>());
    }

    @NonNull
    public static final <A, B> List<Tuple2<A, B>> cross(@NonNull Collection<A> collection1, @NonNull Collection<B> collection2) {
        Ensure.isNotNull("var1", collection2);
        Ensure.isNotNull("var0", collection1);
        return Iterables.cross(collection1, collection2, new ArrayList<Tuple2<A, B>>(collection1.size() * collection2.size()));
    }

    @NonNull
    static <A, B> List<Tuple2<A, B>> cross(@NonNull Iterable<A> iterable1, @NonNull Iterable<B> iterable2, @NonNull List<Tuple2<A, B>> result) {
        for (A a : iterable1) {
            for (B b : iterable2) {
                result.add(Tuples._(a, b));
            }
        }
        return result;
    }
}

