/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom.converter;

import com.zauberlabs.commons.mom.converter.TypeConverter;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class CompositeTypeConverter
implements TypeConverter {
    private final Iterable<TypeConverter> typeConverters;

    public CompositeTypeConverter(@NonNull Iterable<TypeConverter> typeConverters) {
        Ensure.isNotNull("var0", typeConverters);
        this.typeConverters = typeConverters;
    }

    @Override
    public boolean canConvert(@NonNull Class<?> sourceType, @NonNull Class<?> destinationType) {
        Ensure.isNotNull("var1", destinationType);
        Ensure.isNotNull("var0", sourceType);
        return Streams.from(this.typeConverters).any(this.converterCanConvert(sourceType, destinationType));
    }

    @Override
    public <A> A convert(@NonNull Object value, @NonNull Class<A> destinationType) {
        Ensure.isNotNull("var1", destinationType);
        Ensure.isNotNull("var0", value);
        TypeConverter converter = this.findConverter(value, destinationType);
        Ensure.that(converter != null, "No converter found that can convert %s to %s", value, destinationType);
        return converter.convert(value, destinationType);
    }

    protected <A> TypeConverter findConverter(Object value, Class<A> destinationType) {
        return Streams.from(this.typeConverters).findOrNull(this.converterCanConvert(value.getClass(), destinationType));
    }

    private Evaluable<? super TypeConverter> converterCanConvert(final Class<?> sourceType, final Class<?> destinationType) {
        return new AbstractPredicate<TypeConverter>(){

            @Override
            public boolean eval(TypeConverter arg0) {
                return arg0.canConvert(sourceType, destinationType);
            }
        };
    }
}

