/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom;

import com.zauberlabs.commons.mom.MapObjectMapper;
import com.zauberlabs.commons.mom.MapObjectMapperBuilder;
import com.zauberlabs.commons.mom.converter.ConvertUtilsTypeConverter;
import com.zauberlabs.commons.mom.converter.impl.DateToXMLGregorianCalendarTypeConverter;
import com.zauberlabs.commons.mom.converter.impl.StringToEnumTypeConverter;
import com.zauberlabs.commons.mom.internal.DefaultMapObjectMapperBuilder;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import org.apache.commons.beanutils.ConvertUtilsBean;

public final class MapObjectMappers {
    private static final ConvertUtilsTypeConverter BEAN_UTILS_CONVERTER = new ConvertUtilsTypeConverter(new ConvertUtilsBean());

    private MapObjectMappers() {
    }

    public static MapObjectMapper basic(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", packageName);
        return new DefaultMapObjectMapperBuilder(packageName).build();
    }

    public static MapObjectMapperBuilder withPackage(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", packageName);
        return new DefaultMapObjectMapperBuilder(packageName);
    }

    public static MapObjectMapperBuilder defaultWithPackage(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", packageName);
        return MapObjectMappers.withPackage(packageName).withConverter(DateToXMLGregorianCalendarTypeConverter.converter()).withConverter(StringToEnumTypeConverter.converter()).withConverter(BEAN_UTILS_CONVERTER);
    }

    public static MapObjectMapper default_(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", packageName);
        return MapObjectMappers.defaultWithPackage(packageName).build();
    }
}

