/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom;

import com.zauberlabs.commons.mom.MapObjectMapper;
import java.util.List;
import java.util.Map;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class AbstractMapObjectMapper
implements MapObjectMapper {
    @Override
    public Object unmap(Object map) {
        return this.unmapImpl(map, null);
    }

    @Override
    public Object unmap(Object value, @NonNull Class<?> type) {
        Ensure.isNotNull("var1", type);
        return this.unmapImpl(value, type);
    }

    protected Object unmapImpl(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return this.unmapMap((Map)value, type);
        }
        if (value instanceof List) {
            return this.unmapList((List)value, type);
        }
        return this.coerce(value, type);
    }

    protected final <A> A unmapMap(Map<String, Object> map, Class<A> type) {
        Class<A> explicitType = this.explicitType(map);
        if (explicitType != null) {
            return this.unmapMapImpl(map, explicitType);
        }
        if (type != null) {
            return this.unmapMapImpl(map, type);
        }
        return (A)Ensure.that().fail("Must specify key %s", "__javaType");
    }

    protected final List<Object> unmapList(List<Object> objects, final Class<?> componentType) {
        return Streams.from(objects).map(new AbstractFunction<Object, Object>(){

            @Override
            public Object apply(Object arg0) {
                return AbstractMapObjectMapper.this.unmap(arg0, componentType);
            }
        }).toList();
    }

    protected <A> Class<A> explicitType(Map<String, Object> map) {
        if (!map.containsKey("__javaType")) {
            return null;
        }
        Object javaType = map.get("__javaType");
        Ensure.that().isNotNull("__javaType", javaType).isInstanceOf("__javaType", javaType, String.class);
        try {
            return Class.forName((String)javaType);
        }
        catch (ClassNotFoundException e) {
            throw SoftException.soften(e);
        }
    }

    protected abstract <A> A unmapMapImpl(Map<String, Object> var1, Class<A> var2);

    protected abstract Object coerce(Object var1, Class<?> var2);

    @Override
    public Object map(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return this.mapList((List)value);
        }
        if (this.isCompositeType(value.getClass())) {
            return this.mapObject(value);
        }
        return value;
    }

    protected final List<Object> mapList(List<Object> values) {
        return Streams.from(values).map(new AbstractFunction<Object, Object>(){

            @Override
            public Object apply(Object arg0) {
                return AbstractMapObjectMapper.this.map(arg0);
            }
        }).toList();
    }

    protected final Map<String, Object> mapObject(Object value) {
        return this.mapObjectImpl(value);
    }

    protected abstract Map<String, Object> mapObjectImpl(Object var1);

    protected abstract boolean isCompositeType(@NonNull Class<?> var1);
}

