
package org.mule.modules.zendesk.model.transformers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.zendesk.model.Organization;
import org.mule.modules.zendesk.model.holders.EntityExpressionHolder;
import org.mule.modules.zendesk.model.holders.OrganizationExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T05:07:04-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class OrganizationExpressionHolderTransformer
    extends ExpressionEvaluatorSupport
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == OrganizationExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == OrganizationExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {OrganizationExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(OrganizationExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Organization.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Organization.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        OrganizationExpressionHolder holder = ((OrganizationExpressionHolder) src);
        Organization result = new Organization();
        try {
            final String _transformedExternalId = ((String) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_externalIdType").getGenericType(), null, holder.getExternalId()));
            result.setExternalId(_transformedExternalId);
            final String _transformedName = ((String) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_nameType").getGenericType(), null, holder.getName()));
            result.setName(_transformedName);
            final List<String> _transformedDomainNames = ((List<String> ) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_domainNamesType").getGenericType(), null, holder.getDomainNames()));
            result.setDomainNames(_transformedDomainNames);
            final String _transformedDetails = ((String) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_detailsType").getGenericType(), null, holder.getDetails()));
            result.setDetails(_transformedDetails);
            final String _transformedNotes = ((String) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_notesType").getGenericType(), null, holder.getNotes()));
            result.setNotes(_transformedNotes);
            final Long _transformedGroupId = ((Long) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_groupIdType").getGenericType(), null, holder.getGroupId()));
            result.setGroupId(_transformedGroupId);
            final Boolean _transformedSharedTickets = ((Boolean) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_sharedTicketsType").getGenericType(), null, holder.getSharedTickets()));
            result.setSharedTickets(_transformedSharedTickets);
            final Boolean _transformedSharedComments = ((Boolean) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_sharedCommentsType").getGenericType(), null, holder.getSharedComments()));
            result.setSharedComments(_transformedSharedComments);
            final List<String> _transformedTags = ((List<String> ) evaluateAndTransform(this.muleContext, event, OrganizationExpressionHolder.class.getDeclaredField("_tagsType").getGenericType(), null, holder.getTags()));
            result.setTags(_transformedTags);
            final Long _transformedId = ((Long) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_idType").getGenericType(), null, holder.getId()));
            result.setId(_transformedId);
            final String _transformedUrl = ((String) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_urlType").getGenericType(), null, holder.getUrl()));
            result.setUrl(_transformedUrl);
            final Date _transformedCreatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_createdAtType").getGenericType(), null, holder.getCreatedAt()));
            result.setCreatedAt(_transformedCreatedAt);
            final Date _transformedUpdatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_updatedAtType").getGenericType(), null, holder.getUpdatedAt()));
            result.setUpdatedAt(_transformedUpdatedAt);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
