/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.zendesk.jersey;

import com.google.gson.*;
import org.mule.modules.zendesk.model.Entity;
import org.mule.modules.zendesk.model.EntityType;
import org.mule.modules.zendesk.model.responses.SearchResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;

/**
 * @author Mulesoft, Inc
 */
@SuppressWarnings("unchecked")
public class SearchDeserializer implements JsonDeserializer<SearchResponse> {

    public SearchResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = GsonFactory.getRawInstance();
        JsonArray results = json.getAsJsonObject().get("results").getAsJsonArray();
        SearchResponse response = new SearchResponse();

        Entity clazz;
        try {
            if (results != null && results.size() > 0) {
                clazz = (Entity) EntityType.getClassOf(results.get(0).getAsJsonObject().get("result_type").getAsString()).newInstance();
            } else {
                response.setResults(new ArrayList());
                return response;
            }
        } catch (InstantiationException e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        } catch (IllegalAccessException e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }

        ArrayList searchResults = new ArrayList();

        try {
            for (JsonElement obj : results) {
                searchResults.add(gson.fromJson(obj, clazz.getClass()));
            }

            response = gson.fromJson(json, typeOfT);
            response.setResults(searchResults);
        } catch (Exception e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }

        return response;
    }
}
