/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.zendesk.jersey;

import com.google.gson.*;
import org.mule.modules.zendesk.model.Entity;
import org.mule.modules.zendesk.model.EntityType;

import java.lang.reflect.Type;

/**
 * @author Mulesoft, Inc
 */
public class EntitySerializer implements JsonSerializer<Entity> {

    public JsonElement serialize(Entity src, Type typeOfSrc, JsonSerializationContext context) {
        Gson gson = GsonFactory.getRawInstance();

        JsonObject result = new JsonObject();

        result.add(EntityType.getNameToSerialize(src.getClass()), gson.toJsonTree(src));

        return result;
    }
}
