
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/zendesk</code>.
 * 
 */
@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T05:07:04-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class ZendeskNamespaceHandler
    extends NamespaceHandlerSupport
{

    private static Logger logger = LoggerFactory.getLogger(ZendeskNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        } catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [zendesk] is not supported in mule ")+ muleVersion));
        throw new FatalBeanException(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [zendesk] is not supported in mule ")+ muleVersion), noClassDefFoundError);
    }

    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        try {
            this.registerBeanDefinitionParser("config", new ZendeskConnectorConfigDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-current-user", new GetCurrentUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-current-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-ticket", new CreateTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-tickets", new ListTicketsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-tickets", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-ticket", new GetTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-ticket", new UpdateTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-ticket", new DeleteTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-ticket-audits", new ListTicketAuditsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-ticket-audits", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-ticket-audit", new GetTicketAuditDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-ticket-audit", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-ticket-fields", new ListTicketFieldsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-ticket-fields", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-ticket-field", new CreateTicketFieldDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-ticket-field", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-ticket-field", new UpdateTicketFieldDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-ticket-field", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("bulk-import-ticket", new BulkImportTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("bulk-import-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-ticket-metrics", new ListTicketMetricsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-ticket-metrics", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-ticket-metrics", new GetTicketMetricsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-ticket-metrics", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-views", new ListViewsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-views", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-active-views", new ListActiveViewsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-active-views", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-compact-views", new ListCompactViewsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-compact-views", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-view", new GetViewDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-view", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-view", new CreateViewDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-view", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-view", new UpdateViewDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-view", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-tickets-from-view", new GetTicketsFromViewDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-tickets-from-view", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("execute-view", new ExecuteViewDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("execute-view", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-view-counts", new GetViewCountsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-view-counts", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-users", new ListUsersDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-users", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-users-by-organization", new ListUsersByOrganizationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-users-by-organization", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-user", new GetUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-users-by-group", new ListUsersByGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-users-by-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-user-related", new GetUserRelatedDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-user-related", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-user", new CreateUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-user", new UpdateUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-user", new DeleteUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-requests", new ListRequestsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-requests", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-requests-by-status", new ListRequestsByStatusDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-requests-by-status", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-requests-by-user", new ListRequestsByUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-requests-by-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-request", new GetRequestDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-request", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-request", new CreateRequestDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-request", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-request", new UpdateRequestDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-request", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-request-comments", new ListRequestCommentsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-request-comments", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-request-comment", new GetRequestCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-request-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-user-identities", new ListUserIdentitiesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-user-identities", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-user-identity", new GetUserIdentityDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-user-identity", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-user-identity", new CreateUserIdentityDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-user-identity", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("verify-user-identity", new VerifyUserIdentityDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("verify-user-identity", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("make-user-identity-primary", new MakeUserIdentityPrimaryDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("make-user-identity-primary", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("request-user-identity-verification", new RequestUserIdentityVerificationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("request-user-identity-verification", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-user-identity", new DeleteUserIdentityDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-user-identity", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-groups", new ListGroupsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-groups", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-assignable-groups", new ListAssignableGroupsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-assignable-groups", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-group", new GetGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-group", new CreateGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-group", new UpdateGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-group", new DeleteGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-group-memberships", new ListGroupMembershipsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-group-memberships", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-group-memberships-by-user", new ListGroupMembershipsByUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-group-memberships-by-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-group-memberships-by-group", new ListGroupMembershipsByGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-group-memberships-by-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-group-assignable-memberships", new ListGroupAssignableMembershipsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-group-assignable-memberships", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-group-assignable-memberships-by-group", new ListGroupAssignableMembershipsByGroupDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-group-assignable-memberships-by-group", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-group-membership", new GetGroupMembershipDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-group-membership", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-group-membership-by-user", new GetGroupMembershipByUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-group-membership-by-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-group-membership", new CreateGroupMembershipDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-group-membership", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-group-membership", new DeleteGroupMembershipDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-group-membership", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("set-group-membership-as-default", new SetGroupMembershipAsDefaultDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("set-group-membership-as-default", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-organizations", new ListOrganizationsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-organizations", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-organization-related", new GetOrganizationRelatedDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-organization-related", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-organization", new GetOrganizationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-organization", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-organization", new CreateOrganizationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-organization", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-organization", new UpdateOrganizationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-organization", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-organization", new DeleteOrganizationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-organization", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("search-organization", new SearchOrganizationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("search-organization", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-forums", new ListForumsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-forums", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-forums-by-category", new ListForumsByCategoryDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-forums-by-category", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-forum", new GetForumDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-forum", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-forum", new CreateForumDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-forum", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-forum", new UpdateForumDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-forum", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-forum", new DeleteForumDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-forum", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-forum-subscriptions", new ListForumSubscriptionsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-forum-subscriptions", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-forum-subscriptions-by-forum", new ListForumSubscriptionsByForumDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-forum-subscriptions-by-forum", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-forum-subscription", new GetForumSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-forum-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-forum-subscription", new CreateForumSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-forum-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-forum-subscription", new DeleteForumSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-forum-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-categories", new ListCategoriesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-categories", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-category", new GetCategoryDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-category", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-category", new CreateCategoryDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-category", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-category", new UpdateCategoryDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-category", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-category", new DeleteCategoryDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-category", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topics", new ListTopicsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topics", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topics-by-forum", new ListTopicsByForumDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topics-by-forum", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topics-by-user", new ListTopicsByUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topics-by-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-topic", new GetTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-topic", new CreateTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-topic", new UpdateTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("import-topic", new ImportTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("import-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-topic", new DeleteTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topic-comments", new ListTopicCommentsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topic-comments", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topic-comments-by-user", new ListTopicCommentsByUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topic-comments-by-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-topic-comment", new GetTopicCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-topic-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-topic-comment", new CreateTopicCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-topic-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("import-topic-comment", new ImportTopicCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("import-topic-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-topic-comment", new UpdateTopicCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-topic-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-topic-comment", new DeleteTopicCommentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-topic-comment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topic-subscriptions", new ListTopicSubscriptionsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topic-subscriptions", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topic-subscriptions-by-topic", new ListTopicSubscriptionsByTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topic-subscriptions-by-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-topic-subscription", new GetTopicSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-topic-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-topic-subscription", new CreateTopicSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-topic-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-topic-subscription", new DeleteTopicSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-topic-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topic-votes", new ListTopicVotesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topic-votes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topic-votes-by-user", new ListTopicVotesByUserDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topic-votes-by-user", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("check-for-vote", new CheckForVoteDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("check-for-vote", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-topic-vote", new CreateTopicVoteDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-topic-vote", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-topic-vote", new DeleteTopicVoteDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-topic-vote", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-activities", new ListActivitiesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-activities", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-activity", new GetActivityDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-activity", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("upload-attachment", new UploadAttachmentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("upload-attachment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-upload", new DeleteUploadDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-upload", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-attachment", new GetAttachmentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-attachment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-attachment", new DeleteAttachmentDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-attachment", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-automations", new ListAutomationsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-automations", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-automation", new GetAutomationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-automation", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-active-automations", new ListActiveAutomationsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-active-automations", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-automation", new CreateAutomationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-automation", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-automation", new UpdateAutomationDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-automation", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("show-job-status", new ShowJobStatusDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("show-job-status", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-locales", new ListLocalesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-locales", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-locale", new GetLocaleDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-locale", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-current-locale", new GetCurrentLocaleDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-current-locale", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-macros", new ListMacrosDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-macros", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-active-macros", new ListActiveMacrosDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-active-macros", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-macro", new GetMacroDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-macro", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-macro", new CreateMacroDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-macro", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-macro", new UpdateMacroDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-macro", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-macro", new DeleteMacroDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-macro", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("apply-macro", new ApplyMacroDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("apply-macro", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("apply-macro-to-ticket", new ApplyMacroToTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("apply-macro-to-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-satisfaction-ratings", new ListSatisfactionRatingsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-satisfaction-ratings", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-received-satisfaction-ratings", new ListReceivedSatisfactionRatingsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-received-satisfaction-ratings", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-satisfaction-rating", new GetSatisfactionRatingDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-satisfaction-rating", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-satisfaction-rating", new CreateSatisfactionRatingDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-satisfaction-rating", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-sharing-agreements", new ListSharingAgreementsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-sharing-agreements", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-suspended-tickets", new ListSuspendedTicketsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-suspended-tickets", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-suspended-ticket", new GetSuspendedTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-suspended-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("recover-suspended-ticket", new RecoverSuspendedTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("recover-suspended-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-suspended-ticket", new DeleteSuspendedTicketDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-suspended-ticket", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-triggers", new ListTriggersDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-triggers", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-trigger", new GetTriggerDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-trigger", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-active-triggers", new ListActiveTriggersDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-active-triggers", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-trigger", new CreateTriggerDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-trigger", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-trigger", new UpdateTriggerDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("update-trigger", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("search", new SearchDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("search", "@Processor", ex);
        }
    }

}
