
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ActionExpressionHolder;
import org.mule.modules.zendesk.model.holders.MacroExpressionHolder;
import org.mule.modules.zendesk.model.holders.RestrictionExpressionHolder;
import org.mule.modules.zendesk.processors.DeleteMacroMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T05:07:04-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class DeleteMacroDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(DeleteMacroDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(DeleteMacroMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [delete-macro] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [delete-macro] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("deleteMacro");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "macro", "macro", "#[payload]")) {
            BeanDefinitionBuilder macroBuilder = BeanDefinitionBuilder.rootBeanDefinition(MacroExpressionHolder.class.getName());
            Element macroChildElement = DomUtils.getChildElementByTagName(element, "macro");
            if (macroChildElement!= null) {
                parseProperty(macroBuilder, macroChildElement, "id", "id");
                parseProperty(macroBuilder, macroChildElement, "url", "url");
                parseProperty(macroBuilder, macroChildElement, "createdAt", "createdAt");
                parseProperty(macroBuilder, macroChildElement, "updatedAt", "updatedAt");
                parseProperty(macroBuilder, macroChildElement, "title", "title");
                parseProperty(macroBuilder, macroChildElement, "active", "active");
                if (!parseObjectRef(macroChildElement, macroBuilder, "restriction", "restriction")) {
                    BeanDefinitionBuilder _restrictionBuilder = BeanDefinitionBuilder.rootBeanDefinition(RestrictionExpressionHolder.class.getName());
                    Element _restrictionChildElement = DomUtils.getChildElementByTagName(macroChildElement, "restriction");
                    if (_restrictionChildElement!= null) {
                        parseProperty(_restrictionBuilder, _restrictionChildElement, "id", "id");
                        parseProperty(_restrictionBuilder, _restrictionChildElement, "type", "type");
                        macroBuilder.addPropertyValue("restriction", _restrictionBuilder.getBeanDefinition());
                    }
                }
                if (!parseObjectRef(macroChildElement, macroBuilder, "actions", "actions")) {
                    BeanDefinitionBuilder _actionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ActionExpressionHolder.class.getName());
                    Element _actionsChildElement = DomUtils.getChildElementByTagName(macroChildElement, "actions");
                    if (_actionsChildElement!= null) {
                        parseProperty(_actionsBuilder, _actionsChildElement, "field", "field");
                        parseProperty(_actionsBuilder, _actionsChildElement, "value", "value");
                        macroBuilder.addPropertyValue("actions", _actionsBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("macro", macroBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
