
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ForumSubscriptionExpressionHolder;
import org.mule.modules.zendesk.processors.CreateForumSubscriptionMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T05:07:04-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class CreateForumSubscriptionDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateForumSubscriptionDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateForumSubscriptionMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-forum-subscription] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-forum-subscription] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createForumSubscription");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "forum-subscription", "forumSubscription", "#[payload]")) {
            BeanDefinitionBuilder forumSubscriptionBuilder = BeanDefinitionBuilder.rootBeanDefinition(ForumSubscriptionExpressionHolder.class.getName());
            Element forumSubscriptionChildElement = DomUtils.getChildElementByTagName(element, "forum-subscription");
            if (forumSubscriptionChildElement!= null) {
                parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "id", "id");
                parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "url", "url");
                parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "createdAt", "createdAt");
                parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "updatedAt", "updatedAt");
                parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "forumId", "forumId");
                parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "userId", "userId");
                builder.addPropertyValue("forumSubscription", forumSubscriptionBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
