/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScanAnnotationParser;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.annotation.MetadataUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassParser {
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final ImportStack importStack = new ImportStack();
    private final Set<String> knownSuperclasses = new LinkedHashSet<String>();
    private final Set<ConfigurationClass> configurationClasses = new LinkedHashSet<ConfigurationClass>();
    private final Stack<org.springframework.core.env.PropertySource<?>> propertySources = new Stack();
    private final Environment environment;
    private final ResourceLoader resourceLoader;
    private final BeanDefinitionRegistry registry;
    private final ComponentScanAnnotationParser componentScanParser;

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter, Environment environment, ResourceLoader resourceLoader, BeanNameGenerator componentScanBeanNameGenerator, BeanDefinitionRegistry registry) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.environment = environment;
        this.resourceLoader = resourceLoader;
        this.registry = registry;
        this.componentScanParser = new ComponentScanAnnotationParser(resourceLoader, environment, componentScanBeanNameGenerator, registry);
    }

    public void parse(String className, String beanName) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName));
    }

    public void parse(Class<?> clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName));
    }

    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        AnnotationAttributes profile;
        AnnotationMetadata metadata = configClass.getMetadata();
        if (this.environment != null && metadata.isAnnotated(Profile.class.getName()) && !this.environment.acceptsProfiles((profile = MetadataUtils.attributesFor(metadata, Profile.class)).getStringArray("value"))) {
            return;
        }
        while ((metadata = this.doProcessConfigurationClass(configClass, metadata)) != null) {
        }
        if (this.configurationClasses.contains(configClass) && configClass.getBeanName() != null) {
            this.configurationClasses.remove(configClass);
        }
        this.configurationClasses.add(configClass);
    }

    protected AnnotationMetadata doProcessConfigurationClass(ConfigurationClass configClass, AnnotationMetadata metadata) throws IOException {
        String superclass;
        Set<String> imports;
        AnnotationAttributes componentScan;
        for (String memberClassName : metadata.getMemberClassNames()) {
            MetadataReader reader = this.metadataReaderFactory.getMetadataReader(memberClassName);
            AnnotationMetadata memberClassMetadata = reader.getAnnotationMetadata();
            if (!ConfigurationClassUtils.isConfigurationCandidate(memberClassMetadata)) continue;
            this.processConfigurationClass(new ConfigurationClass(reader, true));
        }
        AnnotationAttributes propertySource = MetadataUtils.attributesFor(metadata, PropertySource.class);
        if (propertySource != null) {
            String name = propertySource.getString("name");
            String[] locations = propertySource.getStringArray("value");
            int nLocations = locations.length;
            if (nLocations == 0) {
                throw new IllegalArgumentException("At least one @PropertySource(value) location is required");
            }
            for (int i = 0; i < nLocations; ++i) {
                locations[i] = this.environment.resolveRequiredPlaceholders(locations[i]);
            }
            ClassLoader classLoader = this.resourceLoader.getClassLoader();
            if (!StringUtils.hasText(name)) {
                for (String location : locations) {
                    this.propertySources.push(new ResourcePropertySource(location, classLoader));
                }
            } else if (nLocations == 1) {
                this.propertySources.push(new ResourcePropertySource(name, locations[0], classLoader));
            } else {
                CompositePropertySource ps = new CompositePropertySource(name);
                for (String location : locations) {
                    ps.addPropertySource(new ResourcePropertySource(location, classLoader));
                }
                this.propertySources.push(ps);
            }
        }
        if ((componentScan = MetadataUtils.attributesFor(metadata, ComponentScan.class)) != null) {
            Set<BeanDefinitionHolder> scannedBeanDefinitions = this.componentScanParser.parse(componentScan, metadata.getClassName());
            for (BeanDefinitionHolder holder : scannedBeanDefinitions) {
                if (!ConfigurationClassUtils.checkConfigurationClassCandidate(holder.getBeanDefinition(), this.metadataReaderFactory)) continue;
                this.parse(holder.getBeanDefinition().getBeanClassName(), holder.getBeanName());
            }
        }
        if ((imports = this.getImports(metadata.getClassName(), null, new HashSet<String>())) != null && !imports.isEmpty()) {
            this.processImport(configClass, imports.toArray(new String[imports.size()]), true);
        }
        if (metadata.isAnnotated(ImportResource.class.getName())) {
            AnnotationAttributes importResource = MetadataUtils.attributesFor(metadata, ImportResource.class);
            String[] resources = importResource.getStringArray("value");
            Class readerClass = importResource.getClass("reader");
            for (String resource : resources) {
                configClass.addImportedResource(resource, readerClass);
            }
        }
        Set<MethodMetadata> beanMethods = metadata.getAnnotatedMethods(Bean.class.getName());
        for (MethodMetadata methodMetadata : beanMethods) {
            configClass.addBeanMethod(new BeanMethod(methodMetadata, configClass));
        }
        if (metadata.hasSuperClass() && this.knownSuperclasses.add(superclass = metadata.getSuperClassName())) {
            if (metadata instanceof StandardAnnotationMetadata) {
                Class clazz = ((StandardAnnotationMetadata)metadata).getIntrospectedClass();
                return new StandardAnnotationMetadata(clazz.getSuperclass(), true);
            }
            if (superclass.startsWith("java")) {
                try {
                    return new StandardAnnotationMetadata(this.resourceLoader.getClassLoader().loadClass(superclass), true);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            MetadataReader reader = this.metadataReaderFactory.getMetadataReader(superclass);
            return reader.getAnnotationMetadata();
        }
        return null;
    }

    private Set<String> getImports(String className, Set<String> imports, Set<String> visited) throws IOException {
        if (visited.add(className)) {
            String[] value;
            AnnotationMetadata metadata = this.metadataReaderFactory.getMetadataReader(className).getAnnotationMetadata();
            for (String annotationType : metadata.getAnnotationTypes()) {
                imports = this.getImports(annotationType, imports, visited);
            }
            Map<String, Object> attributes = metadata.getAnnotationAttributes(Import.class.getName(), true);
            if (attributes != null && (value = (String[])attributes.get("value")) != null && value.length > 0) {
                imports = imports == null ? new LinkedHashSet<String>() : imports;
                imports.addAll(Arrays.asList(value));
            }
        }
        return imports;
    }

    private void processImport(ConfigurationClass configClass, String[] classesToImport, boolean checkForCircularImports) throws IOException {
        if (checkForCircularImports && this.importStack.contains(configClass)) {
            this.problemReporter.error(new CircularImportProblem(configClass, this.importStack, configClass.getMetadata()));
        } else {
            this.importStack.push(configClass);
            AnnotationMetadata importingClassMetadata = configClass.getMetadata();
            for (String candidate : classesToImport) {
                MetadataReader reader = this.metadataReaderFactory.getMetadataReader(candidate);
                if (new AssignableTypeFilter(ImportSelector.class).match(reader, this.metadataReaderFactory)) {
                    try {
                        ImportSelector selector = BeanUtils.instantiateClass(this.resourceLoader.getClassLoader().loadClass(candidate), ImportSelector.class);
                        this.processImport(configClass, selector.selectImports(importingClassMetadata), false);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                if (new AssignableTypeFilter(ImportBeanDefinitionRegistrar.class).match(reader, this.metadataReaderFactory)) {
                    try {
                        ImportBeanDefinitionRegistrar registrar = BeanUtils.instantiateClass(this.resourceLoader.getClassLoader().loadClass(candidate), ImportBeanDefinitionRegistrar.class);
                        this.invokeAwareMethods(registrar);
                        registrar.registerBeanDefinitions(importingClassMetadata, this.registry);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                this.importStack.registerImport(importingClassMetadata.getClassName(), candidate);
                this.processConfigurationClass(new ConfigurationClass(reader, true));
            }
            this.importStack.pop();
        }
    }

    private void invokeAwareMethods(ImportBeanDefinitionRegistrar registrar) {
        if (registrar instanceof Aware) {
            if (registrar instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)((Object)registrar)).setResourceLoader(this.resourceLoader);
            }
            if (registrar instanceof BeanClassLoaderAware) {
                ClassLoader classLoader = this.registry instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)((Object)this.registry)).getBeanClassLoader() : this.resourceLoader.getClassLoader();
                ((BeanClassLoaderAware)((Object)registrar)).setBeanClassLoader(classLoader);
            }
            if (registrar instanceof BeanFactoryAware && this.registry instanceof BeanFactory) {
                ((BeanFactoryAware)((Object)registrar)).setBeanFactory((BeanFactory)((Object)this.registry));
            }
        }
    }

    public void validate() {
        for (ConfigurationClass configClass : this.configurationClasses) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getConfigurationClasses() {
        return this.configurationClasses;
    }

    public Stack<org.springframework.core.env.PropertySource<?>> getPropertySources() {
        return this.propertySources;
    }

    public ImportRegistry getImportRegistry() {
        return this.importStack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Stack<ConfigurationClass> importStack, AnnotationMetadata metadata) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack [%s]", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), metadata));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportStack
    extends Stack<ConfigurationClass>
    implements ImportRegistry {
        private final Map<String, String> imports = new HashMap<String, String>();

        private ImportStack() {
        }

        public void registerImport(String importingClass, String importedClass) {
            this.imports.put(importedClass, importingClass);
        }

        @Override
        public String getImportingClassFor(String importedClass) {
            return this.imports.get(importedClass);
        }

        @Override
        public boolean contains(Object elem) {
            ConfigurationClass configClass = (ConfigurationClass)elem;
            Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

                @Override
                public int compare(ConfigurationClass first, ConfigurationClass second) {
                    return first.getMetadata().getClassName().equals(second.getMetadata().getClassName()) ? 0 : 1;
                }
            };
            return Collections.binarySearch(this, configClass, comparator) != -1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("ImportStack: [");
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
                if (!iterator.hasNext()) continue;
                builder.append("->");
            }
            return builder.append(']').toString();
        }
    }

    static interface ImportRegistry {
        public String getImportingClassFor(String var1);
    }
}

