/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter;
import org.mule.modules.zendesk.connection.ConnectionManager;
import org.mule.modules.zendesk.connection.UnableToAcquireConnectionException;
import org.mule.modules.zendesk.connection.UnableToReleaseConnectionException;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionKey;
import org.mule.modules.zendesk.processors.ConnectivityProcessor;
import org.mule.security.oauth.callback.ProcessCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZendeskConnectorManagedConnectionProcessInterceptor<T>
extends ExpressionEvaluatorSupport
implements ProcessInterceptor<T, ZendeskConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ZendeskConnectorManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<ZendeskConnectorConnectionKey, ZendeskConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, ZendeskConnectorConnectionIdentifierAdapter> next;

    public ZendeskConnectorManagedConnectionProcessInterceptor(ProcessInterceptor<T, ZendeskConnectorConnectionIdentifierAdapter> next, ConnectionManager<ZendeskConnectorConnectionKey, ZendeskConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, ZendeskConnectorConnectionIdentifierAdapter> processCallback, ZendeskConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object connectivityProcessor;
        ZendeskConnectorConnectionIdentifierAdapter connection = null;
        ZendeskConnectorConnectionKey key = null;
        if (this.hasConnectionKeysOverride(messageProcessor).booleanValue()) {
            connectivityProcessor = (ConnectivityProcessor)messageProcessor;
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_usernameType"), null, connectivityProcessor.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, connectivityProcessor.typeFor("_passwordType"), null, connectivityProcessor.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            key = new ZendeskConnectorConnectionKey(_transformedUsername, _transformedPassword);
        } else {
            key = this.connectionManager.getEvaluatedConnectionKey(event);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            connectivityProcessor = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)connectivityProcessor;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        if (connection == null) continue;
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    private Boolean hasConnectionKeysOverride(MessageProcessor messageProcessor) {
        if (messageProcessor == null || !(messageProcessor instanceof ConnectivityProcessor)) {
            return false;
        }
        ConnectivityProcessor connectivityProcessor = (ConnectivityProcessor)messageProcessor;
        if (connectivityProcessor.getUsername() != null) {
            return true;
        }
        return false;
    }

    public T execute(ProcessCallback<T, ZendeskConnectorConnectionIdentifierAdapter> processCallback, ZendeskConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

