/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.TopicExpressionHolder;
import org.mule.modules.zendesk.processors.UpdateTopicMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateTopicDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(UpdateTopicDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(UpdateTopicMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [update-topic] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [update-topic] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("updateTopic");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "topic", "topic", "#[payload]")) {
            BeanDefinitionBuilder topicBuilder = BeanDefinitionBuilder.rootBeanDefinition(TopicExpressionHolder.class.getName());
            Element topicChildElement = DomUtils.getChildElementByTagName(element, "topic");
            if (topicChildElement != null) {
                this.parseProperty(topicBuilder, topicChildElement, "id", "id");
                this.parseProperty(topicBuilder, topicChildElement, "url", "url");
                this.parseProperty(topicBuilder, topicChildElement, "createdAt", "createdAt");
                this.parseProperty(topicBuilder, topicChildElement, "updatedAt", "updatedAt");
                this.parseProperty(topicBuilder, topicChildElement, "title", "title");
                this.parseProperty(topicBuilder, topicChildElement, "body", "body");
                this.parseProperty(topicBuilder, topicChildElement, "topicType", "topicType");
                this.parseProperty(topicBuilder, topicChildElement, "submitterId", "submitterId");
                this.parseProperty(topicBuilder, topicChildElement, "updaterId", "updaterId");
                this.parseProperty(topicBuilder, topicChildElement, "forumId", "forumId");
                this.parseProperty(topicBuilder, topicChildElement, "locked", "locked");
                this.parseProperty(topicBuilder, topicChildElement, "pinned", "pinned");
                this.parseProperty(topicBuilder, topicChildElement, "highlighted", "highlighted");
                this.parseProperty(topicBuilder, topicChildElement, "answered", "answered");
                this.parseProperty(topicBuilder, topicChildElement, "commentsCount", "commentsCount");
                this.parseProperty(topicBuilder, topicChildElement, "position", "position");
                this.parseListAndSetProperty(topicChildElement, topicBuilder, "tags", "tags", "tag", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

                    public String parse(Element element) {
                        return element.getTextContent();
                    }
                });
                builder.addPropertyValue("topic", topicBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

