/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.UserIdentityExpressionHolder;
import org.mule.modules.zendesk.processors.CreateUserIdentityMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateUserIdentityDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateUserIdentityDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateUserIdentityMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-user-identity] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-user-identity] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createUserIdentity");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "user-identity", "userIdentity", "#[payload]")) {
            BeanDefinitionBuilder userIdentityBuilder = BeanDefinitionBuilder.rootBeanDefinition(UserIdentityExpressionHolder.class.getName());
            Element userIdentityChildElement = DomUtils.getChildElementByTagName(element, "user-identity");
            if (userIdentityChildElement != null) {
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "id", "id");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "url", "url");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "createdAt", "createdAt");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "updatedAt", "updatedAt");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "userId", "userId");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "type", "type");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "value", "value");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "verified", "verified");
                this.parseProperty(userIdentityBuilder, userIdentityChildElement, "primary", "primary");
                builder.addPropertyValue("userIdentity", userIdentityBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

