/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.OrganizationExpressionHolder;
import org.mule.modules.zendesk.processors.CreateOrganizationMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateOrganizationDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateOrganizationDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateOrganizationMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-organization] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-organization] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createOrganization");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "organization", "organization", "#[payload]")) {
            BeanDefinitionBuilder organizationBuilder = BeanDefinitionBuilder.rootBeanDefinition(OrganizationExpressionHolder.class.getName());
            Element organizationChildElement = DomUtils.getChildElementByTagName(element, "organization");
            if (organizationChildElement != null) {
                this.parseProperty(organizationBuilder, organizationChildElement, "id", "id");
                this.parseProperty(organizationBuilder, organizationChildElement, "url", "url");
                this.parseProperty(organizationBuilder, organizationChildElement, "createdAt", "createdAt");
                this.parseProperty(organizationBuilder, organizationChildElement, "updatedAt", "updatedAt");
                this.parseProperty(organizationBuilder, organizationChildElement, "externalId", "externalId");
                this.parseProperty(organizationBuilder, organizationChildElement, "name", "name");
                this.parseListAndSetProperty(organizationChildElement, organizationBuilder, "domainNames", "domain-names", "domain-name", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

                    public String parse(Element element) {
                        return element.getTextContent();
                    }
                });
                this.parseProperty(organizationBuilder, organizationChildElement, "details", "details");
                this.parseProperty(organizationBuilder, organizationChildElement, "notes", "notes");
                this.parseProperty(organizationBuilder, organizationChildElement, "groupId", "groupId");
                this.parseProperty(organizationBuilder, organizationChildElement, "sharedTickets", "sharedTickets");
                this.parseProperty(organizationBuilder, organizationChildElement, "sharedComments", "sharedComments");
                this.parseListAndSetProperty(organizationChildElement, organizationBuilder, "tags", "tags", "tag", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<String>(){

                    public String parse(Element element) {
                        return element.getTextContent();
                    }
                });
                builder.addPropertyValue("organization", organizationBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

