/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.dom4j.Document;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentSource;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XQueryTransformer
extends AbstractXmlTransformer
implements Disposable {
    public static final String SOURCE_DOCUMENT_NAMESPACE = "document";
    private static final int MIN_IDLE_TRANSFORMERS = 1;
    private static final int MAX_IDLE_TRANSFORMERS = 32;
    private static final int MAX_ACTIVE_TRANSFORMERS = 32;
    protected final GenericObjectPool transformerPool = new GenericObjectPool((PoolableObjectFactory)new PooledXQueryTransformerFactory());
    private volatile String xqueryFile;
    private volatile String xquery;
    private volatile Map<String, Object> contextProperties;
    private volatile XQConnection connection;
    protected Configuration configuration;

    public XQueryTransformer() {
        this.transformerPool.setMinIdle(1);
        this.transformerPool.setMaxIdle(32);
        this.transformerPool.setMaxActive(32);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.create(DocumentSource.class));
        this.registerSourceType(DataTypeFactory.create(Document.class));
        this.registerSourceType(DataTypeFactory.create(org.w3c.dom.Document.class));
        this.registerSourceType(DataTypeFactory.create(Element.class));
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.create(Element.class));
    }

    public XQueryTransformer(String xqueryFile) {
        this();
        this.xqueryFile = xqueryFile;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (this.xquery != null && this.xqueryFile != null) {
            throw new InitialisationException(XmlMessages.canOnlySetFileOrXQuery(), (Initialisable)this);
        }
        try {
            if (this.xqueryFile != null) {
                this.xquery = IOUtils.getResourceAsString((String)this.xqueryFile, ((Object)((Object)this)).getClass());
            }
            if (this.configuration == null) {
                this.configuration = new Configuration();
            }
            SaxonXQDataSource ds = new SaxonXQDataSource(this.configuration);
            this.connection = ds.getConnection();
            this.transformerPool.addObject();
        }
        catch (Throwable te) {
            throw new InitialisationException(te, (Initialisable)this);
        }
    }

    public void dispose() {
        try {
            this.connection.close();
        }
        catch (XQException e) {
            this.logger.warn((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            XQPreparedExpression transformer = null;
            try {
                Object object;
                transformer = (XQPreparedExpression)this.transformerPool.borrowObject();
                this.bindParameters(transformer, message);
                this.bindDocument(message.getPayload(), transformer);
                XQResultSequence result = transformer.executeQuery();
                ArrayList<Object> results = new ArrayList<Object>();
                while (result.next()) {
                    XQItem item = result.getItem();
                    Class type = this.returnType.getType();
                    if (Node.class.isAssignableFrom(type) || Node[].class.isAssignableFrom(type)) {
                        results.add(item.getNode());
                    } else if (String.class.isAssignableFrom(type) || String[].class.isAssignableFrom(type)) {
                        results.add(item.getItemAsString(null));
                    } else {
                        if (XMLStreamReader.class.isAssignableFrom(type) || XMLStreamReader[].class.isAssignableFrom(type)) {
                            try {
                                results.add(item.getItemAsStream());
                            }
                            catch (XQException e) {
                                throw new TransformerException(XmlMessages.streamNotAvailble(this.getName()));
                            }
                        }
                        try {
                            results.add(item.getObject());
                        }
                        catch (XQException e) {
                            throw new TransformerException(XmlMessages.objectNotAvailble(this.getName()));
                        }
                    }
                    if (type.isArray()) continue;
                }
                if (this.returnType.getType().isArray()) {
                    object = results.toArray();
                    return object;
                }
                if (results.size() == 1) {
                    object = results.get(0);
                    return object;
                }
                if (results.size() == 0) {
                    object = null;
                    return object;
                }
                object = results.toArray();
                return object;
            }
            finally {
                if (transformer != null) {
                    this.unbindParameters(transformer);
                    this.transformerPool.returnObject((Object)transformer);
                }
            }
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected void bindParameters(XQPreparedExpression transformer, MuleMessage message) throws XQException, TransformerException {
        if (this.contextProperties != null) {
            for (Map.Entry<String, Object> parameter : this.contextProperties.entrySet()) {
                String key = parameter.getKey();
                Object o = this.evaluateTransformParameter(key, parameter.getValue(), message);
                if (o instanceof String) {
                    transformer.bindAtomicValue(new QName(key), o.toString(), this.connection.createAtomicType(29));
                    continue;
                }
                if (o instanceof Boolean) {
                    transformer.bindBoolean(new QName(key), (Boolean)o, this.connection.createAtomicType(10));
                    continue;
                }
                if (o instanceof Byte) {
                    transformer.bindByte(new QName(key), (Byte)o, this.connection.createAtomicType(31));
                    continue;
                }
                if (o instanceof Short) {
                    transformer.bindShort(new QName(key), (Short)o, this.connection.createAtomicType(14));
                    continue;
                }
                if (o instanceof Integer) {
                    transformer.bindInt(new QName(key), (Integer)o, this.connection.createAtomicType(12));
                    continue;
                }
                if (o instanceof Long) {
                    transformer.bindLong(new QName(key), (Long)o, this.connection.createAtomicType(15));
                    continue;
                }
                if (o instanceof Float) {
                    transformer.bindFloat(new QName(key), ((Float)o).floatValue(), this.connection.createAtomicType(20));
                    continue;
                }
                if (o instanceof Double) {
                    transformer.bindDouble(new QName(key), (Double)o, this.connection.createAtomicType(18));
                    continue;
                }
                this.logger.error((Object)("Cannot bind value: " + o + " cannot be bound to the Xquery context. Not of supported type"));
            }
        }
    }

    protected void unbindParameters(XQPreparedExpression transformer) throws XQException {
        if (this.contextProperties != null) {
            for (Map.Entry<String, Object> parameter : this.contextProperties.entrySet()) {
                String key = parameter.getKey();
                transformer.bindAtomicValue(new QName(key), "", this.connection.createAtomicType(29));
            }
        }
    }

    protected void bindDocument(Object src, XQPreparedExpression transformer) throws Exception {
        if (src instanceof byte[]) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), new StreamSource(new ByteArrayInputStream((byte[])src)), this.connection.createDocumentType());
        } else if (src instanceof InputStream) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), new StreamSource((InputStream)src), this.connection.createDocumentType());
        } else if (src instanceof String) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), new StreamSource(new ByteArrayInputStream(((String)src).getBytes())), this.connection.createDocumentType());
        } else if (src instanceof org.w3c.dom.Document) {
            transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), (org.w3c.dom.Document)src, this.connection.createDocumentType());
        } else if (src instanceof Element) {
            transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), (Element)src, this.connection.createDocumentType());
        } else if (src instanceof Document) {
            DOMWriter domWriter = new DOMWriter();
            org.w3c.dom.Document dom = domWriter.write((Document)src);
            transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), dom, this.connection.createDocumentType());
        } else if (src instanceof DocumentSource) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), (DocumentSource)src, null);
        } else {
            throw new IllegalArgumentException(CoreMessages.transformUnexpectedType(src.getClass(), null).getMessage());
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getXqueryFile() {
        return this.xqueryFile;
    }

    public void setXqueryFile(String xqueryFile) {
        this.xqueryFile = xqueryFile;
    }

    public String getXquery() {
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }

    public int getMaxActiveTransformers() {
        return this.transformerPool.getMaxActive();
    }

    public void setMaxActiveTransformers(int maxActiveTransformers) {
        this.transformerPool.setMaxActive(maxActiveTransformers);
    }

    public int getMaxIdleTransformers() {
        return this.transformerPool.getMaxIdle();
    }

    public void setMaxIdleTransformers(int maxIdleTransformers) {
        this.transformerPool.setMaxIdle(maxIdleTransformers);
    }

    public Map<String, Object> getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
    }

    protected Object evaluateTransformParameter(String name, Object value, MuleMessage message) throws TransformerException {
        if (value instanceof String) {
            return this.muleContext.getExpressionManager().parse(value.toString(), message);
        }
        return value;
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        try {
            ((Initialisable)clone).initialise();
            return clone;
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(CoreMessages.failedToClone((String)((Object)((Object)this)).getClass().getName()), (Throwable)e);
        }
    }

    protected class PooledXQueryTransformerFactory
    extends BasePoolableObjectFactory {
        protected PooledXQueryTransformerFactory() {
        }

        public Object makeObject() throws Exception {
            return XQueryTransformer.this.connection.prepareExpression(XQueryTransformer.this.xquery);
        }

        public void destroyObject(Object o) throws Exception {
            ((XQPreparedExpression)o).close();
            super.destroyObject(o);
        }
    }
}

