/*
 * Decompiled with CFR 0.152.
 */
package org.mule.commons.jersey;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import org.mule.commons.jersey.DefaultResponseHandler;
import org.mule.commons.jersey.RequestBehaviour;
import org.mule.commons.jersey.ResponseHandler;

public class JerseyUtil {
    private List<RequestBehaviour> requestBehaviour = new ArrayList<RequestBehaviour>();
    private ResponseHandler responseHandler;

    private JerseyUtil() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T delete(WebResource resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("DELETE", resource, entityClass, expectedStatus);
    }

    public <T> T post(WebResource resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("POST", resource, entityClass, expectedStatus);
    }

    public <T> T put(WebResource resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("PUT", resource, entityClass, expectedStatus);
    }

    public <T> T get(WebResource resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("GET", resource, entityClass, expectedStatus);
    }

    public <T> T delete(WebResource.Builder resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("DELETE", resource, entityClass, expectedStatus);
    }

    public <T> T post(WebResource.Builder resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("POST", resource, entityClass, expectedStatus);
    }

    public <T> T put(WebResource.Builder resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("PUT", resource, entityClass, expectedStatus);
    }

    public <T> T get(WebResource.Builder resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("GET", resource, entityClass, expectedStatus);
    }

    public <T> T options(WebResource resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("OPTIONS", resource.getRequestBuilder(), entityClass, expectedStatus);
    }

    public <T> T options(WebResource.Builder resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute("OPTIONS", resource, entityClass, expectedStatus);
    }

    public <T> T execute(String method, WebResource resource, Class<T> entityClass, int ... expectedStatus) {
        return this.execute(method, resource.getRequestBuilder(), entityClass, expectedStatus);
    }

    public <T> T execute(String method, WebResource.Builder builder, Class<T> entityClass, int ... expectedStatus) {
        for (RequestBehaviour b : this.requestBehaviour) {
            builder = b.behave(builder, method, entityClass);
        }
        ClientResponse response = builder.method(method, ClientResponse.class);
        int status = response.getStatus();
        if (this.contains(expectedStatus, status)) {
            return status != ClientResponse.Status.NO_CONTENT.getStatusCode() ? this.responseHandler.onSuccess(response, entityClass) : this.responseHandler.onNoContent(response);
        }
        return this.responseHandler.onFailure(response, status, expectedStatus);
    }

    private boolean contains(int[] expected, int obtained) {
        if (expected == null || expected.length == 0) {
            return true;
        }
        for (int i : expected) {
            if (i != obtained) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private JerseyUtil util = new JerseyUtil();

        private Builder() {
        }

        public Builder addRequestBehaviour(RequestBehaviour behaviour) {
            this.util.requestBehaviour.add(behaviour);
            return this;
        }

        public Builder setResponseHandler(ResponseHandler handler) {
            this.util.responseHandler = handler;
            return this;
        }

        public JerseyUtil build() {
            if (this.util.responseHandler == null) {
                this.util.responseHandler = new DefaultResponseHandler();
            }
            return this.util;
        }
    }
}

