/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.value;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.restrictions.check.NonNull;

public enum BasicEquals {
    ALWAYS{

        @Override
        public boolean toEquals() {
            return true;
        }

        @Override
        public boolean isEqualsDone() {
            return true;
        }
    }
    ,
    NEVER{

        @Override
        public boolean toEquals() {
            return false;
        }

        @Override
        public boolean isEqualsDone() {
            return true;
        }
    }
    ,
    MAYBE{

        @Override
        public boolean toEquals() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isEqualsDone() {
            return false;
        }
    };


    private BasicEquals() {
    }

    @NonNull
    public static <T> BasicEquals from(@NonNull T this_, Object that) {
        Ensure.isNotNull("var0", this_);
        if (that == null) {
            return NEVER;
        }
        if (that == this_) {
            return ALWAYS;
        }
        if (that.getClass() != this_.getClass()) {
            return NEVER;
        }
        return MAYBE;
    }

    public abstract boolean toEquals();

    public abstract boolean isEqualsDone();

    /* synthetic */ BasicEquals(String string, int n, BasicEquals basicEquals) {
        this();
    }
}

