/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.defs.tuple.Tuple3;
import net.sf.staccatocommons.lang.tuple.AbstractTuple;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class Triple<A, B, C>
extends AbstractTuple
implements Tuple3<A, B, C> {
    private static final long serialVersionUID = 5811264763831754560L;
    private static final RelevantState<Tuple3> VAL = new AbstractTuple.TupleState<Tuple3>(3){

        @Override
        protected void collectState(Tuple3 o, RelevantState.StateCollector b) {
            b.add(o.first()).add(o.second()).add(o.third());
        }
    };
    private final A first;
    private final B second;
    private final C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public A first() {
        return this.first;
    }

    @Override
    public B second() {
        return this.second;
    }

    @Override
    public C third() {
        return this.third;
    }

    @Override
    public A _0() {
        return this.first();
    }

    @Override
    public B _1() {
        return this.second();
    }

    @Override
    public C _2() {
        return this.third();
    }

    @Override
    @NonNull
    public Tuple3<B, C, A> rotateLeft() {
        return new Triple<B, C, A>(this.second, this.third, this.first);
    }

    @Override
    @NonNull
    public Tuple3<C, A, B> rotateRight() {
        return new Triple<C, A, B>(this.third, this.first, this.second);
    }

    public String toString() {
        return VAL.toString(this);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return new Object[]{this.first, this.second, this.third};
    }

    public int hashCode() {
        return VAL.hashCode(this);
    }

    public boolean equals(Object obj) {
        return VAL.equals(this, obj);
    }

    @Override
    public int compareTo(Tuple3<A, B, C> other) {
        return VAL.compareTo(this, other);
    }
}

