/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.function;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.function.Function3;
import net.sf.staccatocommons.defs.tuple.Tuple2;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractDelayable2;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction3;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class AbstractFunction2<A, B, C>
extends AbstractDelayable2<A, B, C>
implements Function2<A, B, C> {
    @Override
    @NonNull
    public Function<B, C> apply(final A arg0) {
        return new AbstractFunction<B, C>(){

            @Override
            public C apply(B arg1) {
                return AbstractFunction2.this.apply(arg0, arg1);
            }
        };
    }

    @Override
    public Function2<B, A, C> flip() {
        return new AbstractFunction2<B, A, C>(){

            @Override
            public C apply(B arg1, A arg0) {
                return AbstractFunction2.this.apply(arg0, arg1);
            }
        };
    }

    @Override
    public final Function2<A, B, C> nullSafe() {
        return new AbstractFunction2<A, B, C>(){

            @Override
            public C apply(A arg0, B arg1) {
                if (arg0 == null || arg1 == null) {
                    return null;
                }
                return AbstractFunction2.this.apply(arg0, arg1);
            }
        };
    }

    @Override
    public <D> Function2<D, B, C> of(final @NonNull Applicable<? super D, ? extends A> function) {
        Ensure.isNotNull("var0", function);
        return new AbstractFunction2<D, B, C>(){

            @Override
            public C apply(D arg0, B arg1) {
                return AbstractFunction2.this.apply(function.apply(arg0), arg1);
            }
        };
    }

    @Override
    public <A2, B2, D> Function3<A, B, A2, D> then(final @NonNull Function2<C, B2, D> combinator, final @NonNull Function<? super A2, ? extends B2> other) {
        Ensure.isNotNull("var1", other);
        Ensure.isNotNull("var0", combinator);
        return new AbstractFunction3<A, B, A2, D>(){

            @Override
            public D apply(A arg0, B arg1, A2 arg2) {
                return combinator.apply(AbstractFunction2.this.apply(arg0, arg1), other.apply(arg2));
            }
        };
    }

    @Override
    public <D> Function2<A, B, D> then(Function<? super C, ? extends D> other) {
        return other.of(this);
    }

    @Override
    public Function<Tuple2<A, B>, C> uncurry() {
        return new AbstractFunction<Tuple2<A, B>, C>(){

            @Override
            public C apply(Tuple2<A, B> argument) {
                return AbstractFunction2.this.apply(argument.first(), argument.second());
            }
        };
    }

    public String toString() {
        return "Function2";
    }

    public static abstract class Soft<A, B, C>
    extends AbstractFunction2<A, B, C> {
        @Override
        public final C apply(A arg0, B arg1) {
            try {
                return this.softApply(arg0, arg1);
            }
            catch (Throwable e) {
                throw SoftException.soften(e);
            }
        }

        protected abstract C softApply(A var1, B var2) throws Throwable;
    }
}

