/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.function;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Applicable2;
import net.sf.staccatocommons.defs.Applicable3;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.function.Function3;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractDelayable;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.AbstractFunction3;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class AbstractFunction<A, B>
extends AbstractDelayable<A, B>
implements Function<A, B> {
    @Override
    @NonNull
    public <C> Function<C, B> of(final @NonNull Applicable<? super C, ? extends A> other) {
        Ensure.isNotNull("var0", other);
        return new AbstractFunction<C, B>(){

            @Override
            public B apply(C arg) {
                return AbstractFunction.this.apply(other.apply(arg));
            }
        };
    }

    @Override
    @NonNull
    public <Tp1, Tp2> Function2<Tp1, Tp2, B> of(final @NonNull Applicable2<Tp1, Tp2, ? extends A> other) {
        Ensure.isNotNull("var0", other);
        return new AbstractFunction2<Tp1, Tp2, B>(){

            @Override
            public B apply(Tp1 arg0, Tp2 arg1) {
                return AbstractFunction.this.apply(other.apply(arg0, arg1));
            }
        };
    }

    @Override
    @NonNull
    public <Tp1, Tp2, Tp3> Function3<Tp1, Tp2, Tp3, B> of(final @NonNull Applicable3<Tp1, Tp2, Tp3, ? extends A> other) {
        Ensure.isNotNull("var0", other);
        return new AbstractFunction3<Tp1, Tp2, Tp3, B>(){

            @Override
            public B apply(Tp1 arg0, Tp2 arg1, Tp3 arg2) {
                return AbstractFunction.this.apply(other.apply(arg0, arg1, arg2));
            }
        };
    }

    @Override
    @NonNull
    public Function<A, B> nullSafe() {
        return new AbstractFunction<A, B>(){

            @Override
            public B apply(A arg) {
                if (arg == null) {
                    return null;
                }
                return AbstractFunction.this.apply(arg);
            }
        };
    }

    @Override
    public <C> Function<A, C> then(@NonNull Function<? super B, ? extends C> other) {
        Ensure.isNotNull("var0", other);
        return other.of(this);
    }

    @Override
    public Predicate<A> then(@NonNull Predicate<? super B> other) {
        Ensure.isNotNull("var0", other);
        return other.of(this);
    }

    @Override
    public Predicate<A> equal(final B object) {
        return new AbstractPredicate<A>(){

            @Override
            public boolean eval(A argument) {
                return AbstractFunction.this.apply(argument).equals(object);
            }
        };
    }

    @Override
    public Predicate<A> same(final B object) {
        return new AbstractPredicate<A>(){

            @Override
            public boolean eval(A argument) {
                return AbstractFunction.this.apply(argument) == object;
            }
        };
    }

    @Override
    public Predicate<A> notNull() {
        return new AbstractPredicate<A>(){

            @Override
            public boolean eval(A argument) {
                return AbstractFunction.this.apply(argument) != null;
            }
        };
    }

    @Override
    public Predicate<A> null_() {
        return new AbstractPredicate<A>(){

            @Override
            public boolean eval(A argument) {
                return AbstractFunction.this.apply(argument) == null;
            }
        };
    }

    @Override
    public <A2, B2, C> Function2<A, A2, C> then(final Function2<B, B2, C> combinator, final Function<? super A2, ? extends B2> other) {
        return new AbstractFunction2<A, A2, C>(){

            @Override
            public C apply(A arg0, A2 arg1) {
                return combinator.apply(AbstractFunction.this.apply(arg0), other.apply(arg1));
            }
        };
    }

    public String toString() {
        return "Function";
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    public static abstract class Soft<A, B>
    extends AbstractFunction<A, B> {
        @Override
        public final B apply(A arg) {
            try {
                return this.softApply(arg);
            }
            catch (Throwable e) {
                throw SoftException.soften(e);
            }
        }

        protected abstract B softApply(A var1) throws Throwable;
    }
}

