/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.block;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.partial.NullSafeAware;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.lang.function.AbstractDelayable;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class Block<T>
extends AbstractDelayable<T, Void>
implements Executable<T>,
NullSafeAware<Block<T>> {
    @Override
    public void exec(@NonNull T argument) {
        Ensure.isNotNull("var0", argument);
        try {
            this.softExec(argument);
        }
        catch (Throwable e) {
            throw SoftException.soften(e);
        }
    }

    protected void softExec(T argument) throws Throwable {
    }

    @Override
    public Void apply(T arg) {
        this.exec(arg);
        return null;
    }

    @Override
    public Block<T> nullSafe() {
        return new Block<T>(){

            @Override
            public void exec(T argument) {
                if (argument == null) {
                    return;
                }
                Block.this.exec(argument);
            }
        };
    }

    @NonNull
    public Block<T> then(final @NonNull Executable<? super T> other) {
        Ensure.isNotNull("var0", other);
        return new Block<T>(){

            @Override
            public void exec(T argument) {
                Block.this.exec(argument);
                other.exec(argument);
            }
        };
    }

    public String toString() {
        return "Block";
    }
}

