/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.lang.builder.Builder;
import net.sf.staccatocommons.lang.builder.BuilderAlreadyUsedException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.Functions;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class MapBuilder<K, V, M extends Map<K, V>>
implements Builder<M> {
    private M map;
    private Applicable<M, M> wrapperFunction;
    private static final Function TO_UNMODIFIABLE_MAP = MapBuilder.toUnmodifiableMapInitializer();
    private static final Function TO_UNMODIFIABLE_SORTED_MAP = MapBuilder.toUnmodifiableSortedMapInitializer();

    public MapBuilder(@NonNull M map, @NonNull Applicable<M, M> wrapperFunction) {
        Ensure.isNotNull("var1", wrapperFunction);
        Ensure.isNotNull("var0", map);
        this.map = map;
        this.wrapperFunction = wrapperFunction;
    }

    @NonNull
    public MapBuilder<K, V, M> with(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    @NonNull
    public MapBuilder<K, V, M> with(@NonNull Map.Entry<K, V> entry) {
        Ensure.isNotNull("var0", entry);
        this.map.put(entry.getKey(), entry.getValue());
        return this;
    }

    @NonNull
    public MapBuilder<K, V, M> withWrapper(@NonNull Applicable<M, M> wrapperFunction) {
        Ensure.isNotNull("var0", wrapperFunction);
        this.wrapperFunction = wrapperFunction;
        return this;
    }

    @NonNull
    public MapBuilder<K, V, M> unwrap() {
        return this.withWrapper(Functions.identity());
    }

    @Override
    @NonNull
    public M build() {
        M map = this.map;
        this.map = null;
        if (map == null) {
            throw new BuilderAlreadyUsedException();
        }
        return (M)((Map)this.wrapperFunction.apply(map));
    }

    @NonNull
    public static <K, V> MapBuilder<K, V, Map<K, V>> from(@NonNull Map<K, V> map) {
        Ensure.isNotNull("var0", map);
        return MapBuilder.from(map, (Applicable)MapBuilder.toUnmodifiableMap());
    }

    @NonNull
    public static <K, V> MapBuilder<K, V, Map<K, V>> mapWith(K key, V value) {
        return MapBuilder.from(new HashMap()).with(key, value);
    }

    @NonNull
    public static <K, V> MapBuilder<K, V, Map<K, V>> linkedMapWith(K key, V value) {
        return MapBuilder.from(new LinkedHashMap()).with(key, value);
    }

    @NonNull
    public static <K, V> MapBuilder<K, V, SortedMap<K, V>> treeMapWith(K key, V value) {
        return MapBuilder.from(new TreeMap(), (Applicable)MapBuilder.toUnmodifiableSortedMap()).with(key, value);
    }

    @NonNull
    static <K, V, M extends Map<K, V>> MapBuilder<K, V, M> from(@NonNull M map, Applicable<M, M> wrapperFunction) {
        return new MapBuilder<K, V, M>(map, wrapperFunction);
    }

    @Constant
    public static <K, V> Function<Map<K, V>, Map<K, V>> toUnmodifiableMap() {
        return TO_UNMODIFIABLE_MAP;
    }

    @Constant
    public static <K, V> Function<SortedMap<K, V>, SortedMap<K, V>> toUnmodifiableSortedMap() {
        return TO_UNMODIFIABLE_SORTED_MAP;
    }

    private static Function toUnmodifiableMapInitializer() {
        return new AbstractFunction<Map<K, V>, Map<K, V>>(){

            @Override
            public Map<K, V> apply(Map<K, V> arg) {
                return Collections.unmodifiableMap(arg);
            }
        };
    }

    private static Function toUnmodifiableSortedMapInitializer() {
        return new AbstractFunction<SortedMap<K, V>, SortedMap<K, V>>(){

            @Override
            public SortedMap<K, V> apply(SortedMap<K, V> arg) {
                return Collections.unmodifiableSortedMap(arg);
            }
        };
    }
}

