/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.util.Comparator;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.internal.NaturalComparator;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.lang.predicate.internal.GreaterThan;
import net.sf.staccatocommons.lang.predicate.internal.LessThan;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.IgnoreRestrictions;

public class Compare {
    @IgnoreRestrictions
    public static <T extends Comparable<T>> boolean between(@NonNull T element, @NonNull T min, @NonNull T max) {
        return Compare.between(element, min, max, Compare.natural());
    }

    public static <T> boolean between(@NonNull T element, @NonNull T min, @NonNull T max, @NonNull Comparator<T> comparator) {
        Ensure.isNotNull("var3", comparator);
        Ensure.isNotNull("var2", max);
        Ensure.isNotNull("var1", min);
        Ensure.isNotNull("var0", element);
        return comparator.compare(element, max) <= 0 && comparator.compare(element, min) >= 0;
    }

    public static boolean between(long element, long min, long max) {
        return element <= max && element >= min;
    }

    public static boolean between(int element, int min, int max) {
        return element <= max && element >= min;
    }

    public static <T extends Comparable<T>> Predicate<T> between(final @NonNull T min, final @NonNull T max) {
        Ensure.isNotNull("var1", max);
        Ensure.isNotNull("var0", min);
        return new AbstractPredicate<T>(){

            @Override
            public boolean eval(T argument) {
                return Compare.between(argument, min, max);
            }
        };
    }

    public static boolean in(int element, @NonNull int[] values) {
        Ensure.isNotNull("var1", values);
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (element == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean in(long element, @NonNull long[] values) {
        Ensure.isNotNull("var1", values);
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            if (element == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean in(@NonNull T element, T ... values) {
        Ensure.isNotNull("var1", values);
        Ensure.isNotNull("var0", element);
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (element.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @IgnoreRestrictions
    public static <T> Predicate<T> in_(T ... values) {
        return Predicates.in(values);
    }

    @NonNull
    @IgnoreRestrictions
    public static <T extends Comparable<T>> T min(@NonNull T c1, @NonNull T c2) {
        return Compare.min(c1, c2, Compare.natural());
    }

    @NonNull
    @IgnoreRestrictions
    public static <T extends Comparable<T>> T max(@NonNull T c1, @NonNull T c2) {
        return Compare.max(c1, c2, Compare.natural());
    }

    @NonNull
    public static <A> Function2<A, A, A> min(final @NonNull Comparator<? super A> comparator) {
        Ensure.isNotNull("var0", comparator);
        return new AbstractFunction2<A, A, A>(){

            @Override
            public A apply(A arg0, A arg1) {
                return Compare.min(arg0, arg1, comparator);
            }
        };
    }

    @NonNull
    public static <A> Function2<A, A, A> max(final @NonNull Comparator<? super A> comparator) {
        Ensure.isNotNull("var0", comparator);
        return new AbstractFunction2<A, A, A>(){

            @Override
            public A apply(A arg0, A arg1) {
                return Compare.max(arg0, arg1, comparator);
            }
        };
    }

    @NonNull
    public static <T> T max(@NonNull T c1, @NonNull T c2, @NonNull Comparator<? super T> comparator) {
        Ensure.isNotNull("var2", comparator);
        Ensure.isNotNull("var1", c2);
        Ensure.isNotNull("var0", c1);
        return comparator.compare(c1, c2) >= 0 ? c1 : c2;
    }

    @NonNull
    public static <T> T min(@NonNull T c1, @NonNull T c2, Comparator<? super T> comparator) {
        Ensure.isNotNull("var1", c2);
        Ensure.isNotNull("var0", c1);
        return comparator.compare(c1, c2) <= 0 ? c1 : c2;
    }

    @NonNull
    public static <A, B extends Comparable<B>> Comparator<A> on(final @NonNull Applicable<? super A, B> function) {
        Ensure.isNotNull("var0", function);
        return new Comparator<A>(){

            @Override
            public int compare(A arg0, A arg1) {
                return ((Comparable)function.apply(arg0)).compareTo((Comparable)function.apply(arg1));
            }
        };
    }

    public static <T extends Comparable<T>> Predicate<T> lessThan(@NonNull T value) {
        Ensure.isNotNull("var0", value);
        return new LessThan<T>(value);
    }

    @IgnoreRestrictions
    public static <T extends Comparable<T>> Predicate<T> lessThanOrEqualTo(@NonNull T value) {
        return Compare.greaterThan(value).not();
    }

    public static <T extends Comparable<T>> Predicate<T> greaterThan(@NonNull T value) {
        Ensure.isNotNull("var0", value);
        return new GreaterThan<T>(value);
    }

    @IgnoreRestrictions
    public static <T extends Comparable<T>> Predicate<T> greaterThanOrEqualTo(@NonNull T value) {
        return Compare.lessThan(value).not();
    }

    @Constant
    public static <A extends Comparable<A>> Comparator<A> natural() {
        return NaturalComparator.natural();
    }
}

