/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.internal.algorithms;

import java.io.Serializable;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.iterators.thriter.NextThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class IterateStream<A>
extends AbstractStream<A>
implements Serializable {
    private static final long serialVersionUID = 8811454338704704525L;
    private final A seed;
    private final Applicable<? super A, ? extends A> generator;

    public IterateStream(A seed, @NonNull Applicable<? super A, ? extends A> generator) {
        this.seed = seed;
        this.generator = generator;
    }

    @Override
    public Thriterator<A> iterator() {
        return new NextThriterator<A>(){
            private A next;
            {
                this.next = IterateStream.this.seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            protected A nextImpl() {
                Object next = this.next;
                this.next = IterateStream.this.generator.apply(next);
                return next;
            }
        };
    }
}

