/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.iterable;

import java.util.Collection;
import java.util.Iterator;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.iterable.internal.IterablesInternal;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotNegative;

public class ModifiableIterables {
    @NonNull
    public static <T, I extends Iterable<T>> I removeAll(@NonNull I iterable, @NonNull Evaluable<? super T> predicate) {
        Ensure.isNotNull("var1", predicate);
        Ensure.isNotNull("var0", iterable);
        Iterator<T> iter = iterable.iterator();
        while (iter.hasNext()) {
            if (!predicate.eval(iter.next())) continue;
            iter.remove();
        }
        return iterable;
    }

    public static <T, I extends Iterable<T>> I removeWhile(@NonNull I iterable, @NonNull Evaluable<? super T> predicate) {
        Ensure.isNotNull("var1", predicate);
        Ensure.isNotNull("var0", iterable);
        Iterator<T> iter = iterable.iterator();
        while (iter.hasNext() && predicate.eval(iter.next())) {
            iter.remove();
        }
        return iterable;
    }

    @NonNull
    public static <I extends Iterable<?>> I remove(@NonNull I iterable, @NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var1", amountOfElements);
        Ensure.isNotNull("var0", iterable);
        Iterator<?> iter = iterable.iterator();
        int i = 0;
        while (i < amountOfElements && iter.hasNext()) {
            iter.remove();
            ++i;
        }
        return iterable;
    }

    @NonNull
    public static <T, C extends Collection<T>> C addAll(@NonNull C collection, @NonNull Iterable<? extends T> iterable) {
        Ensure.isNotNull("var1", iterable);
        Ensure.isNotNull("var0", collection);
        IterablesInternal.addAllInternal(collection, iterable);
        return collection;
    }

    @NonNull
    public static <T, C extends Collection<T>> C move(@NonNull Iterable<T> iterable, @NonNull C collection, @NonNull Evaluable<T> predicate) {
        Ensure.isNotNull("var2", predicate);
        Ensure.isNotNull("var1", collection);
        Ensure.isNotNull("var0", iterable);
        Iterator<T> iter = iterable.iterator();
        while (iter.hasNext()) {
            T element = iter.next();
            if (!predicate.eval(element)) continue;
            iter.remove();
            collection.add(element);
        }
        return collection;
    }

    @NonNull
    public static <T, C extends Collection<T>> C move(@NonNull Iterable<T> iterable, @NotNegative int amountOfElements, @NonNull C collection) {
        Ensure.isNotNull("var2", collection);
        Ensure.that().isNotNegative("var1", amountOfElements);
        Ensure.isNotNull("var0", iterable);
        Iterator<T> iter = iterable.iterator();
        int i = 0;
        while (i < amountOfElements && iter.hasNext()) {
            collection.add(iter.next());
            iter.remove();
            ++i;
        }
        return collection;
    }
}

