/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.internal.iterator;

import java.util.NoSuchElementException;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class TakeIterator<A>
extends AdvanceThriterator<A> {
    private int remaining;
    private final Thriter<A> thriter;

    public TakeIterator(int n, @NonNull Thriter<A> thriter) {
        this.thriter = thriter;
        this.remaining = n;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0 && this.thriter.hasNext();
    }

    @Override
    public void advanceNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.thriter.advanceNext();
        --this.remaining;
    }

    @Override
    public A current() throws NoSuchElementException {
        return this.thriter.current();
    }

    @Override
    public Thunk<A> delayedCurrent() {
        return this.thriter.delayedCurrent();
    }
}

