/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom.internal;

import com.zauberlabs.commons.mom.MapObjectMapper;
import com.zauberlabs.commons.mom.PropertyModel;
import com.zauberlabs.commons.mom.StructureType;
import com.zauberlabs.commons.mom.style.NamingStyle;
import com.zauberlabs.commons.mom.style.SetterStyle;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class SimplePropertyModel
implements PropertyModel {
    private final SetterStyle setterStyle;
    private final NamingStyle namingStyle;

    public SimplePropertyModel(@NonNull SetterStyle setterStyle, @NonNull NamingStyle namingStyle) {
        this.setterStyle = setterStyle;
        this.namingStyle = namingStyle;
    }

    @Override
    public void setProperty(Object propertyValue, Object destination, String mapKey, MapObjectMapper mom) {
        String propertyName = this.namingStyle.getPropertyName(mapKey);
        Class<?> targetType = StructureType.getStructureType(destination, propertyName);
        try {
            this.setterStyle.setValue(destination, propertyName, mom.unmap(propertyValue, targetType));
        }
        catch (Exception e) {
            throw SoftException.soften(e);
        }
    }
}

