/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom.internal;

import com.zauberlabs.commons.mom.MapObjectMapper;
import com.zauberlabs.commons.mom.MapObjectMapperBuilder;
import com.zauberlabs.commons.mom.MapObjectMapperInterceptor;
import com.zauberlabs.commons.mom.PropertyModel;
import com.zauberlabs.commons.mom.converter.CompositeTypeConverter;
import com.zauberlabs.commons.mom.converter.IdentityTypeConverter;
import com.zauberlabs.commons.mom.converter.TypeConverter;
import com.zauberlabs.commons.mom.internal.DefaultMapObjectMapper;
import com.zauberlabs.commons.mom.internal.InterceptingMapObjectMapper;
import com.zauberlabs.commons.mom.internal.SimplePropertyModel;
import com.zauberlabs.commons.mom.style.NamingStyle;
import com.zauberlabs.commons.mom.style.SetterStyle;
import com.zauberlabs.commons.mom.style.impl.BeanNamingStyle;
import com.zauberlabs.commons.mom.style.impl.BeanStyle;
import java.util.LinkedList;
import java.util.List;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.Nulls;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import net.sf.staccatocommons.restrictions.processing.EnforceRestrictions;

@EnforceRestrictions
public class DefaultMapObjectMapperBuilder
implements MapObjectMapperBuilder {
    private final String packageName;
    private SetterStyle setterStyle;
    private NamingStyle namingStyle;
    private PropertyModel propertyModel;
    private List<TypeConverter> converters;
    private MapObjectMapperInterceptor interceptor;

    public DefaultMapObjectMapperBuilder(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", packageName);
        this.converters = new LinkedList<TypeConverter>();
        this.interceptor = null;
        this.packageName = packageName;
        this.withConverter(IdentityTypeConverter.converter());
    }

    @Override
    public final MapObjectMapperBuilder withSetterStyle(@NonNull SetterStyle style) {
        Ensure.isNotNull("var0", style);
        this.setterStyle = style;
        return this;
    }

    @Override
    public final MapObjectMapperBuilder withConverter(@NonNull TypeConverter converter) {
        Ensure.isNotNull("var0", converter);
        this.converters.add(converter);
        return this;
    }

    @Override
    public final MapObjectMapperBuilder withInterceptor(@NonNull MapObjectMapperInterceptor inter) {
        Ensure.isNotNull("var0", inter);
        this.interceptor = inter;
        return this;
    }

    @Override
    public final MapObjectMapperBuilder withNamingStyle(@NonNull NamingStyle style) {
        Ensure.isNotNull("var0", style);
        this.namingStyle = style;
        return this;
    }

    @Override
    public final MapObjectMapperBuilder withPropertyModel(@NonNull PropertyModel model) {
        Ensure.isNotNull("var0", model);
        this.propertyModel = model;
        return this;
    }

    @Override
    public MapObjectMapper build() {
        if (this.interceptor == null) {
            return new DefaultMapObjectMapper(this.packageName, this.buildPropertyModel(), this.buildTypeConverter());
        }
        return new InterceptingMapObjectMapper(this.packageName, this.buildPropertyModel(), this.buildTypeConverter(), this.interceptor);
    }

    private PropertyModel buildPropertyModel() {
        if (this.propertyModel != null) {
            Ensure.that(this.setterStyle == null, "Either set the property model or the setter style, but not both", new Object[0]);
            Ensure.that(this.namingStyle == null, "Either set the property model or the naming style, but not both", new Object[0]);
            return this.propertyModel;
        }
        return new SimplePropertyModel(this.buildSetterStyle(), this.buildNamingStyle());
    }

    private NamingStyle buildNamingStyle() {
        return Nulls.coalesce(this.namingStyle, BeanNamingStyle.syle());
    }

    private SetterStyle buildSetterStyle() {
        return Nulls.coalesce(this.setterStyle, BeanStyle.STYLE);
    }

    private CompositeTypeConverter buildTypeConverter() {
        return new CompositeTypeConverter(this.converters);
    }
}

