/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom.internal;

import com.zauberlabs.commons.mom.AbstractMapObjectMapper;
import com.zauberlabs.commons.mom.PropertyModel;
import com.zauberlabs.commons.mom.converter.TypeConverter;
import com.zauberlabs.commons.mom.internal.AttributesMap;
import com.zauberlabs.commons.mom.internal.MappingPackage;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.EnforceRestrictions;

@EnforceRestrictions
public class DefaultMapObjectMapper
extends AbstractMapObjectMapper {
    private final MappingPackage mappingPackage;
    private final TypeConverter typeConverter;
    private final PropertyModel propertyModel;

    public DefaultMapObjectMapper(@NonNull String packageName, @NonNull PropertyModel propertyModel, @NonNull TypeConverter typeConverter) {
        Ensure.isNotNull("var2", typeConverter);
        Ensure.isNotNull("var1", propertyModel);
        Ensure.isNotNull("var0", packageName);
        this.mappingPackage = new MappingPackage(packageName);
        this.typeConverter = typeConverter;
        this.propertyModel = propertyModel;
    }

    @Override
    public boolean isCompositeType(@NonNull Class<?> clazz) {
        Ensure.isNotNull("var0", clazz);
        return this.mappingPackage.isInMappeablePackage(clazz);
    }

    @Override
    protected Map<String, Object> mapObjectImpl(Object value) {
        Ensure.that(this.isCompositeType(value.getClass()), "%s must be a composite type", value);
        return new AttributesMap(value, this);
    }

    @Override
    protected Object coerce(Object value, Class<?> type) {
        return this.typeConverter.convert(value, type);
    }

    @Override
    protected <A> A unmapMapImpl(Map<String, Object> map, Class<A> targetType) {
        try {
            A bean = targetType.newInstance();
            this.unmapProperties(map, bean);
            return bean;
        }
        catch (Exception e) {
            throw SoftException.soften(e);
        }
    }

    protected void unmapProperties(@NonNull Map<String, Object> source, @NonNull Object destination) throws IllegalAccessException, InvocationTargetException {
        Ensure.isNotNull("var1", destination);
        Ensure.isNotNull("var0", source);
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            if (entry.getKey().equals("__javaType")) continue;
            this.propertyModel.setProperty(entry.getValue(), destination, entry.getKey(), this);
        }
    }
}

