/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom.converter.impl;

import com.zauberlabs.commons.mom.converter.TypeConverter;
import net.sf.staccatocommons.restrictions.Constant;

public final class StringToEnumTypeConverter
implements TypeConverter {
    private static final StringToEnumTypeConverter CONVERTER = StringToEnumTypeConverter.converterInitializer();

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> destinationType) {
        return sourceType == String.class && destinationType.isEnum();
    }

    @Override
    public <A> A convert(Object value, Class<A> destinationType) {
        return Enum.valueOf(destinationType, (String)value);
    }

    @Constant
    public static StringToEnumTypeConverter converter() {
        return CONVERTER;
    }

    private static StringToEnumTypeConverter converterInitializer() {
        return new StringToEnumTypeConverter();
    }
}

