/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl.provider.entity;

import com.sun.jersey.core.util.FeaturesAndProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;

public class JacksonProviderProxy
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    JacksonJsonProvider pojoProvider = new JacksonJsonProvider();
    JacksonJaxbJsonProvider jaxbProvider = new JacksonJaxbJsonProvider();
    boolean jacksonEntityProviderFeatureSet = false;

    @Context
    public void setFeaturesAndProperties(FeaturesAndProperties fp) {
        this.jacksonEntityProviderFeatureSet = fp.getFeature("com.sun.jersey.api.json.POJOMappingFeature");
    }

    @Context
    public void setProviders(Providers p) {
        ContextResolver<ObjectMapper> omResolver = p.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE);
        if (omResolver != null) {
            ObjectMapper mapper = omResolver.getContext(ObjectMapper.class);
            this.pojoProvider.setMapper(mapper);
            this.jaxbProvider.setMapper(mapper);
        }
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.jacksonEntityProviderFeatureSet && (this.jaxbProvider.isReadable(type, genericType, annotations, mediaType) || this.pojoProvider.isReadable(type, genericType, annotations, mediaType));
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.jaxbProvider.isReadable(type, genericType, annotations, mediaType) ? this.jaxbProvider.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream) : this.pojoProvider.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.jacksonEntityProviderFeatureSet && (this.jaxbProvider.isWriteable(type, genericType, annotations, mediaType) || this.pojoProvider.isWriteable(type, genericType, annotations, mediaType));
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.jaxbProvider.isWriteable(type, genericType, annotations, mediaType) ? this.jaxbProvider.getSize(t, type, genericType, annotations, mediaType) : this.pojoProvider.getSize(t, type, genericType, annotations, mediaType);
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (this.jaxbProvider.isWriteable(type, genericType, annotations, mediaType)) {
            this.jaxbProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
        } else {
            this.pojoProvider.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
    }
}

