
package org.mule.modules.zendesk.model.transformers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.zendesk.model.CustomField;
import org.mule.modules.zendesk.model.SatisfactionRating;
import org.mule.modules.zendesk.model.Ticket;
import org.mule.modules.zendesk.model.TicketComment;
import org.mule.modules.zendesk.model.TicketStatus;
import org.mule.modules.zendesk.model.Via;
import org.mule.modules.zendesk.model.holders.EntityExpressionHolder;
import org.mule.modules.zendesk.model.holders.TicketExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T11:32:57-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class TicketExpressionHolderTransformer
    extends ExpressionEvaluatorSupport
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == TicketExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == TicketExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {TicketExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(TicketExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Ticket.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Ticket.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        TicketExpressionHolder holder = ((TicketExpressionHolder) src);
        Ticket result = new Ticket();
        try {
            final String _transformedExternalId = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_externalIdType").getGenericType(), null, holder.getExternalId()));
            result.setExternalId(_transformedExternalId);
            final String _transformedType = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_typeType").getGenericType(), null, holder.getType()));
            result.setType(_transformedType);
            final String _transformedSubject = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_subjectType").getGenericType(), null, holder.getSubject()));
            result.setSubject(_transformedSubject);
            final String _transformedDescription = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_descriptionType").getGenericType(), null, holder.getDescription()));
            result.setDescription(_transformedDescription);
            final String _transformedPriority = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_priorityType").getGenericType(), null, holder.getPriority()));
            result.setPriority(_transformedPriority);
            final TicketStatus _transformedStatus = ((TicketStatus) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_statusType").getGenericType(), null, holder.getStatus()));
            result.setStatus(_transformedStatus);
            final String _transformedRecipient = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_recipientType").getGenericType(), null, holder.getRecipient()));
            result.setRecipient(_transformedRecipient);
            final String _transformedRequesterId = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_requesterIdType").getGenericType(), null, holder.getRequesterId()));
            result.setRequesterId(_transformedRequesterId);
            final String _transformedSubmitterId = ((String) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_submitterIdType").getGenericType(), null, holder.getSubmitterId()));
            result.setSubmitterId(_transformedSubmitterId);
            final Long _transformedAssigneeId = ((Long) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_assigneeIdType").getGenericType(), null, holder.getAssigneeId()));
            result.setAssigneeId(_transformedAssigneeId);
            final Long _transformedOrganizationId = ((Long) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_organizationIdType").getGenericType(), null, holder.getOrganizationId()));
            result.setOrganizationId(_transformedOrganizationId);
            final Long _transformedGroupId = ((Long) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_groupIdType").getGenericType(), null, holder.getGroupId()));
            result.setGroupId(_transformedGroupId);
            final List<String> _transformedCollaboratorIds = ((List<String> ) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_collaboratorIdsType").getGenericType(), null, holder.getCollaboratorIds()));
            result.setCollaboratorIds(_transformedCollaboratorIds);
            final Long _transformedForumTopicId = ((Long) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_forumTopicIdType").getGenericType(), null, holder.getForumTopicId()));
            result.setForumTopicId(_transformedForumTopicId);
            final Long _transformedProblemId = ((Long) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_problemIdType").getGenericType(), null, holder.getProblemId()));
            result.setProblemId(_transformedProblemId);
            final Boolean _transformedHasIncidents = ((Boolean) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_hasIncidentsType").getGenericType(), null, holder.getHasIncidents()));
            result.setHasIncidents(_transformedHasIncidents);
            final Date _transformedDueAt = ((Date) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_dueAtType").getGenericType(), null, holder.getDueAt()));
            result.setDueAt(_transformedDueAt);
            final List<String> _transformedTags = ((List<String> ) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_tagsType").getGenericType(), null, holder.getTags()));
            result.setTags(_transformedTags);
            final Via _transformedVia = ((Via) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_viaType").getGenericType(), null, holder.getVia()));
            result.setVia(_transformedVia);
            final List<CustomField> _transformedCustomFields = ((List<CustomField> ) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_customFieldsType").getGenericType(), null, holder.getCustomFields()));
            result.setCustomFields(_transformedCustomFields);
            final List<CustomField> _transformedFields = ((List<CustomField> ) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_fieldsType").getGenericType(), null, holder.getFields()));
            result.setFields(_transformedFields);
            final SatisfactionRating _transformedSatisfactionRating = ((SatisfactionRating) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_satisfactionRatingType").getGenericType(), null, holder.getSatisfactionRating()));
            result.setSatisfactionRating(_transformedSatisfactionRating);
            final List<String> _transformedSharingAgreementIds = ((List<String> ) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_sharingAgreementIdsType").getGenericType(), null, holder.getSharingAgreementIds()));
            result.setSharingAgreementIds(_transformedSharingAgreementIds);
            final List<String> _transformedFollowupIds = ((List<String> ) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_followupIdsType").getGenericType(), null, holder.getFollowupIds()));
            result.setFollowupIds(_transformedFollowupIds);
            final Long _transformedTicketFormId = ((Long) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_ticketFormIdType").getGenericType(), null, holder.getTicketFormId()));
            result.setTicketFormId(_transformedTicketFormId);
            final TicketComment _transformedComment = ((TicketComment) evaluateAndTransform(this.muleContext, event, TicketExpressionHolder.class.getDeclaredField("_commentType").getGenericType(), null, holder.getComment()));
            result.setComment(_transformedComment);
            final Long _transformedId = ((Long) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_idType").getGenericType(), null, holder.getId()));
            result.setId(_transformedId);
            final String _transformedUrl = ((String) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_urlType").getGenericType(), null, holder.getUrl()));
            result.setUrl(_transformedUrl);
            final Date _transformedCreatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_createdAtType").getGenericType(), null, holder.getCreatedAt()));
            result.setCreatedAt(_transformedCreatedAt);
            final Date _transformedUpdatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_updatedAtType").getGenericType(), null, holder.getUpdatedAt()));
            result.setUpdatedAt(_transformedUpdatedAt);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
