/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.zendesk.model;

import java.util.List;

/**
 * Class used for Zendesk's Requests objects. A request is an end-user's perspective on a ticket
 *
 * @author Mulesoft, Inc
 */
public class Request extends Entity {

    private String subject;
    private String description;
    private String status;
    private List<CustomField> customFields;
    private Long organizationId;
    private Long requesterid;
    private Via via;

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<CustomField> getCustomFields() {
        return customFields;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Long getRequesterid() {
        return requesterid;
    }

    public void setRequesterid(Long requesterid) {
        this.requesterid = requesterid;
    }

    public Via getVia() {
        return via;
    }

    public void setVia(Via via) {
        this.via = via;
    }
}
