/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.zendesk.jersey;

import com.sun.jersey.api.client.ClientResponse;
import org.mule.commons.jersey.ResponseHandler;
import org.mule.modules.zendesk.model.responses.ErrorResponse;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

/**
 * @author Mulesoft, Inc
 */
public class ZendeskResponseHandler implements ResponseHandler {

    public <T> T onSuccess(ClientResponse response, Class<T> entityType) {
        return response.getEntity(entityType);
    }

    public <T> T onFailure(ClientResponse response, int status, int[] expectedStatus) {
        ErrorResponse errorResponse = response.getEntity(ErrorResponse.class);
        throw new ZendeskException(String.format("Error trying to call Zendesk services. Status [%s]. Response: [%s]. Error: [%s] ; %s", status, response.toString(),
                errorResponse.getDescription(), showErrorDetails(errorResponse.getDetails())));
    }

    public <T> T onNoContent(ClientResponse response) {
        return null;
    }

    private String showErrorDetails(Map<String, Object> errorDetails) {
        StringBuilder errorString = new StringBuilder();
        errorString.append("Details: ");

        if (errorDetails != null) {
            Iterator it = errorDetails.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry) it.next();
                errorString.append(entry.getValue().toString());
            }
        }

        return errorString.toString();
    }
}
