
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ActionExpressionHolder;
import org.mule.modules.zendesk.model.holders.AutomationExpressionHolder;
import org.mule.modules.zendesk.model.holders.ConditionExpressionHolder;
import org.mule.modules.zendesk.model.holders.ConditionsExpressionHolder;
import org.mule.modules.zendesk.processors.UpdateAutomationMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser.ParseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T11:32:57-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class UpdateAutomationDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(UpdateAutomationDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(UpdateAutomationMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [update-automation] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [update-automation] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("updateAutomation");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "automation", "automation", "#[payload]")) {
            BeanDefinitionBuilder automationBuilder = BeanDefinitionBuilder.rootBeanDefinition(AutomationExpressionHolder.class.getName());
            Element automationChildElement = DomUtils.getChildElementByTagName(element, "automation");
            if (automationChildElement!= null) {
                parseProperty(automationBuilder, automationChildElement, "id", "id");
                parseProperty(automationBuilder, automationChildElement, "url", "url");
                parseProperty(automationBuilder, automationChildElement, "createdAt", "createdAt");
                parseProperty(automationBuilder, automationChildElement, "updatedAt", "updatedAt");
                parseProperty(automationBuilder, automationChildElement, "title", "title");
                parseProperty(automationBuilder, automationChildElement, "active", "active");
                if (!parseObjectRef(automationChildElement, automationBuilder, "conditions", "conditions")) {
                    BeanDefinitionBuilder _conditionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConditionsExpressionHolder.class.getName());
                    Element _conditionsChildElement = DomUtils.getChildElementByTagName(automationChildElement, "conditions");
                    if (_conditionsChildElement!= null) {
                        parseListAndSetProperty(_conditionsChildElement, _conditionsBuilder, "all", "all", "all", new ParseDelegate<BeanDefinition>() {


                            public BeanDefinition parse(Element element) {
                                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConditionExpressionHolder.class);
                                parseProperty(builder, element, "field", "field");
                                parseProperty(builder, element, "operator", "operator");
                                parseProperty(builder, element, "value", "value");
                                return builder.getBeanDefinition();
                            }

                        }
                        );
                        parseListAndSetProperty(_conditionsChildElement, _conditionsBuilder, "any", "any", "any", new ParseDelegate<BeanDefinition>() {


                            public BeanDefinition parse(Element element) {
                                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConditionExpressionHolder.class);
                                parseProperty(builder, element, "field", "field");
                                parseProperty(builder, element, "operator", "operator");
                                parseProperty(builder, element, "value", "value");
                                return builder.getBeanDefinition();
                            }

                        }
                        );
                        automationBuilder.addPropertyValue("conditions", _conditionsBuilder.getBeanDefinition());
                    }
                }
                if (!parseObjectRef(automationChildElement, automationBuilder, "actions", "actions")) {
                    BeanDefinitionBuilder _actionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ActionExpressionHolder.class.getName());
                    Element _actionsChildElement = DomUtils.getChildElementByTagName(automationChildElement, "actions");
                    if (_actionsChildElement!= null) {
                        parseProperty(_actionsBuilder, _actionsChildElement, "field", "field");
                        parseProperty(_actionsBuilder, _actionsChildElement, "value", "value");
                        automationBuilder.addPropertyValue("actions", _actionsBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("automation", automationBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
