
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ForumExpressionHolder;
import org.mule.modules.zendesk.processors.DeleteForumMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T11:32:57-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class DeleteForumDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(DeleteForumDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(DeleteForumMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [delete-forum] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [delete-forum] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("deleteForum");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "forum", "forum", "#[payload]")) {
            BeanDefinitionBuilder forumBuilder = BeanDefinitionBuilder.rootBeanDefinition(ForumExpressionHolder.class.getName());
            Element forumChildElement = DomUtils.getChildElementByTagName(element, "forum");
            if (forumChildElement!= null) {
                parseProperty(forumBuilder, forumChildElement, "id", "id");
                parseProperty(forumBuilder, forumChildElement, "url", "url");
                parseProperty(forumBuilder, forumChildElement, "createdAt", "createdAt");
                parseProperty(forumBuilder, forumChildElement, "updatedAt", "updatedAt");
                parseProperty(forumBuilder, forumChildElement, "name", "name");
                parseProperty(forumBuilder, forumChildElement, "description", "description");
                parseProperty(forumBuilder, forumChildElement, "categoryId", "categoryId");
                parseProperty(forumBuilder, forumChildElement, "organizationId", "organizationId");
                parseProperty(forumBuilder, forumChildElement, "localeId", "localeId");
                parseProperty(forumBuilder, forumChildElement, "locked", "locked");
                parseProperty(forumBuilder, forumChildElement, "unansweredTopics", "unansweredTopics");
                parseProperty(forumBuilder, forumChildElement, "position", "position");
                parseProperty(forumBuilder, forumChildElement, "forum_type", "forum_type");
                parseProperty(forumBuilder, forumChildElement, "access", "access");
                builder.addPropertyValue("forum", forumBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
