
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.SatisfactionRatingExpressionHolder;
import org.mule.modules.zendesk.processors.CreateSatisfactionRatingMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2016-05-19T11:32:57-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class CreateSatisfactionRatingDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateSatisfactionRatingDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateSatisfactionRatingMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-satisfaction-rating] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-satisfaction-rating] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createSatisfactionRating");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "satisfaction-rating", "satisfactionRating", "#[payload]")) {
            BeanDefinitionBuilder satisfactionRatingBuilder = BeanDefinitionBuilder.rootBeanDefinition(SatisfactionRatingExpressionHolder.class.getName());
            Element satisfactionRatingChildElement = DomUtils.getChildElementByTagName(element, "satisfaction-rating");
            if (satisfactionRatingChildElement!= null) {
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "id", "id");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "url", "url");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "createdAt", "createdAt");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "updatedAt", "updatedAt");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "assigneeId", "assigneeId");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "groupId", "groupId");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "requesterId", "requesterId");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "ticketId", "ticketId");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "score", "score");
                parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "comment", "comment");
                builder.addPropertyValue("satisfactionRating", satisfactionRatingBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
