/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.access;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.JmxException;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.access.ConnectorDelegate;
import org.springframework.jmx.support.NotificationListenerHolder;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationListenerRegistrar
extends NotificationListenerHolder
implements InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MBeanServerConnection server;
    private JMXServiceURL serviceUrl;
    private Map<String, ?> environment;
    private String agentId;
    private final ConnectorDelegate connector = new ConnectorDelegate();
    private ObjectName[] actualObjectNames;

    public void setServer(MBeanServerConnection server) {
        this.server = server;
    }

    public void setEnvironment(Map<String, ?> environment) {
        this.environment = environment;
    }

    public Map<String, ?> getEnvironment() {
        return this.environment;
    }

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getNotificationListener() == null) {
            throw new IllegalArgumentException("Property 'notificationListener' is required");
        }
        if (CollectionUtils.isEmpty(this.mappedObjectNames)) {
            throw new IllegalArgumentException("Property 'mappedObjectName' is required");
        }
        this.prepare();
    }

    public void prepare() {
        if (this.server == null) {
            this.server = this.connector.connect(this.serviceUrl, this.environment, this.agentId);
        }
        try {
            this.actualObjectNames = this.getResolvedObjectNames();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering NotificationListener for MBeans " + Arrays.asList(this.actualObjectNames)));
            }
            for (ObjectName actualObjectName : this.actualObjectNames) {
                this.server.addNotificationListener(actualObjectName, this.getNotificationListener(), this.getNotificationFilter(), this.getHandback());
            }
        }
        catch (IOException ex) {
            throw new MBeanServerNotFoundException("Could not connect to remote MBeanServer at URL [" + this.serviceUrl + "]", ex);
        }
        catch (Exception ex) {
            throw new JmxException("Unable to register NotificationListener", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            if (this.actualObjectNames != null) {
                for (ObjectName actualObjectName : this.actualObjectNames) {
                    try {
                        this.server.removeNotificationListener(actualObjectName, this.getNotificationListener(), this.getNotificationFilter(), this.getHandback());
                    }
                    catch (Exception ex) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)"Unable to unregister NotificationListener", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            this.connector.close();
        }
    }
}

