/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.QueueProfile;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.AbstractConnector;
import org.mule.transport.vm.VMMessageReceiver;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;

public class VMConnector
extends AbstractConnector {
    public static final String VM = "vm";
    private QueueProfile queueProfile;
    private Integer queueTimeout;

    public VMConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        if (this.queueTimeout == null) {
            this.queueTimeout = this.muleContext.getConfiguration().getDefaultQueueTimeout();
        }
        if (this.queueProfile == null) {
            this.queueProfile = QueueProfile.newInstancePersistingToDefaultMemoryQueueStore((MuleContext)this.muleContext);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("created default QueueProfile for VM connector: " + this.queueProfile));
            }
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        if (!endpoint.getExchangePattern().hasResponse()) {
            this.queueProfile.configureQueue(endpoint.getMuleContext(), endpoint.getEndpointURI().getAddress(), this.getQueueManager());
        }
        return this.serviceDescriptor.createMessageReceiver((Connector)this, flowConstruct, endpoint);
    }

    public String getProtocol() {
        return "VM";
    }

    public String getCanonicalURI(EndpointURI uri) {
        String canonicalURI = super.getCanonicalURI(uri);
        if (!canonicalURI.contains("?connector=")) {
            canonicalURI = String.format("%s?connector=%s", canonicalURI, this.getName());
        }
        return canonicalURI;
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    VMMessageReceiver getReceiver(EndpointURI endpointUri) throws EndpointException {
        return (VMMessageReceiver)this.getReceiverByEndpoint(endpointUri);
    }

    QueueSession getQueueSession() throws InitialisationException {
        return this.getQueueManager().getQueueSession();
    }

    protected MessageReceiver getReceiverByEndpoint(EndpointURI endpointUri) throws EndpointException {
        MessageReceiver receiver2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up vm receiver for address: " + endpointUri.toString()));
        }
        if ((receiver2 = (MessageReceiver)this.receivers.get(endpointUri.getAddress())) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found exact receiver match on endpointUri: " + endpointUri));
            }
            return receiver2;
        }
        for (MessageReceiver receiver2 : this.receivers.values()) {
            String filterAddress = receiver2.getEndpointURI().getAddress();
            WildcardFilter filter = new WildcardFilter(filterAddress);
            if (!filter.accept((Object)endpointUri.getAddress())) continue;
            InboundEndpoint endpoint = receiver2.getEndpoint();
            MuleEndpointURI newEndpointURI = new MuleEndpointURI(endpointUri, filterAddress);
            receiver2.setEndpoint((InboundEndpoint)new DynamicURIInboundEndpoint(endpoint, (EndpointURI)newEndpointURI));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found receiver match on endpointUri: " + receiver2.getEndpointURI() + " against " + endpointUri));
            }
            return receiver2;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No receiver found for endpointUri: " + endpointUri));
        }
        return null;
    }

    public boolean isResponseEnabled() {
        return true;
    }

    public int getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(int queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public QueueManager getQueueManager() {
        return this.getMuleContext().getQueueManager();
    }

    protected <T> T createOperationResource(ImmutableEndpoint endpoint) throws MuleException {
        return (T)this.getQueueManager().getQueueSession();
    }

    protected <T> T getOperationResourceFactory() {
        return (T)this.getQueueManager();
    }
}

